"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var Presets_1 = tslib_1.__importDefault(require("./Presets"));
var Preset = /** @class */ (function () {
    function Preset(presetId, apiCall) {
        this.presetId = presetId;
        this.apiCall = apiCall;
    }
    Preset.prototype.retrieve = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, this.apiCall.get(this.endpointPath())];
            });
        });
    };
    Preset.prototype.delete = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, this.apiCall.delete(this.endpointPath())];
            });
        });
    };
    Preset.prototype.endpointPath = function () {
        return "".concat(Presets_1.default.RESOURCEPATH, "/").concat(encodeURIComponent(this.presetId));
    };
    return Preset;
}());
exports.default = Preset;
//# sourceMappingURL=Preset.js.map