export type EngineType =
  | 'web'
  | 'images'
  | 'videos'
  | 'news'
  | 'shopping'
  | 'books';

export type SearchEngine = {
  id: EngineType;
  label: string;
  cx: string;
  isImage?: boolean;
};

export const ENGINES: SearchEngine[] = [
  {
    id: 'web',
    label: 'All',
    cx: process.env.NEXT_PUBLIC_CSE_WEB!,
  },
  {
    id: 'images',
    label: 'Images',
    cx: process.env.NEXT_PUBLIC_CSE_IMAGES!,
    isImage: true,
  },
  {
    id: 'videos',
    label: 'Videos',
    cx: process.env.NEXT_PUBLIC_CSE_VIDEOS!,
  },
  {
    id: 'news',
    label: 'News',
    cx: process.env.NEXT_PUBLIC_CSE_NEWS!,
  },
  {
    id: 'shopping',
    label: 'Shopping',
    cx: process.env.NEXT_PUBLIC_CSE_SHOPPING!,
  },
  {
    id: 'books',
    label: 'Books',
    cx: process.env.NEXT_PUBLIC_CSE_BOOKS!,
  },
];

export const DEFAULT_ENGINE: EngineType = 'web';

export function getEngine(id?: string) {
  return ENGINES.find(e => e.id === id) ||
         ENGINES.find(e => e.id === DEFAULT_ENGINE)!;
}
