export async function copyToClipboard(text: string): Promise<boolean> {
  try {
    if (!navigator?.clipboard) {
      throw new Error("Clipboard API not supported");
    }

    await navigator.clipboard.writeText(text);
    return true;
  } catch (err) {
    console.error("Copy failed:", err);
    return false;
  }
}
