"use client";

import { useEffect, useState } from "react";

/** 🔹 Global in-memory store */
const store = new Map<string, any>();

export function usePreservedResults<T>(key: string) {
  const [data, setData] = useState<T | null>(() => {
    return store.get(key) ?? null;
  });

  // keep state in sync with store on mount
  useEffect(() => {
    if (store.has(key)) {
      setData(store.get(key));
    }
  }, [key]);

  const setResults = (value: T | ((prev: T | null) => T)) => {
    setData((prev) => {
      const next =
        typeof value === "function"
          ? (value as any)(prev)
          : value;

      store.set(key, next);
      return next;
    });
  };

  return {
    preserveData : data,
    setPreservedData: setResults,
    hasData: store.has(key),
  };
}
