// context/SettingsContext.tsx
"use client";

import { createContext, useContext, useState } from "react";

type SettingsContextType = {
  tab: string;
  setTab: (tab: string) => void;
};

const SettingsContext = createContext<SettingsContextType | null>(null);

export function SettingsContextProvider({ children }: { children: React.ReactNode }) {
  const [tab, setTab] = useState("You and Indzs");
  // console.log(tab)
  return (
    <SettingsContext.Provider value={{ tab, setTab }}>
      {children}
    </SettingsContext.Provider>
  );
}

export function useSettings() {
  const context = useContext(SettingsContext);

  if (!context) {
    throw new Error(
      "useSettings must be used inside SettingsProvider"
    );
  }

  return context;
}
