"use client"
import React, { useState } from "react";
import { Mail, Lock, X, UserPlus, Fingerprint, Loader2 } from "lucide-react";
import { useAuth } from "@/components/auth-provider"
import { useRouter } from "next/navigation"

interface LoginModalProps {
  isOpen: boolean;
  onClose: () => void;
  onLogin: () => void;
}

export function LoginModal({ isOpen, onClose, onLogin }: LoginModalProps) {
  const { login, register } = useAuth()
  const router = useRouter()
  const [loading, setLoading] = useState(false)
  const [error, setError] = useState("")

  // Login form state
  const [loginData, setLoginData] = useState({
    username: "",
    password: "",
  })

  const handleLogin = async (e: React.FormEvent) => {
    e.preventDefault()
    console.log(loginData)
    setLoading(true)
    setError("")

    const result = await login(loginData.username, loginData.password)
    if (result.success) {
      onClose()
      // router.push("/ads-center")
    } else {
      if (result.requiresVerification) {
        setError("Please verify your email address before signing in. Check your inbox for a verification link.")
        // setVerificationEmail(loginData.username)
        // setShowVerificationMessage(true)
      } else {
        setError(result.error || "Invalid username or password")
      }
    }
    setLoading(false)
  }



  if (!isOpen) return null;

  return (
    <div>
      <div className="fixed inset-0 z-50 flex items-center justify-center p-4 sm:p-6  animate-in fade-in duration-300">
        <div
          className="relative w-full max-w-md p-6 sm:p-10 rounded-[2rem] border shadow-2xl animate-in zoom-in-95 slide-in-from-bottom-4 duration-300"
          style={{ backgroundColor: 'var(--card)', borderColor: 'var(--border)' }}
        >
          {/* Close Button */}
          <button
            onClick={onClose}
            className="absolute top-5 right-5 p-2 rounded-full hover:bg-white/5 transition-colors focus:ring-2 focus:ring-offset-2 focus:ring-offset-black"
            style={{ outlineColor: 'var(--ring)' }}
          >
            <X size={20} style={{ color: 'var(--muted-foreground)' }} />
          </button>

          {/* Header */}
          <div className="text-center mb-6 sm:mb-8">
            <div className="w-12 h-12 sm:w-14 sm:h-14 rounded-2xl flex items-center justify-center mx-auto mb-4 border shadow-inner"
              style={{ backgroundColor: 'var(--muted)', borderColor: 'var(--border)' }}>
              <Fingerprint size={24} className="sm:size-7" style={{ color: 'var(--chart-1)' }} />
            </div>
            <h2 className="text-xl sm:text-2xl font-bold tracking-tight" style={{ color: 'var(--foreground)' }}>
              Welcome Back
          </h2>
            <p className="text-xs sm:text-sm mt-1" style={{ color: 'var(--muted-foreground)' }}>
              Sign in to your Indzs Account
          </p>
          </div>

          {/* Form */}
          {/* Alert Section */}
          {error && (
            <div className="add-web-alert">
              <span className="add-web-alert-icon">⚠️</span>
              <span className="add-web-alert-msg">{error}</span>
            </div>
          )}

          <form className="space-y-4" onSubmit={handleLogin}>
            <div className="space-y-1.5">
              <label className="text-[10px] font-bold uppercase tracking-widest opacity-50 ml-1">Email</label>
              <div className="relative group">
                <Mail className="absolute left-4 top-1/2 -translate-y-1/2  group-focus-within:opacity-100 transition-opacity" size={18} />
                <input
                  type="text"
                  placeholder="name@example.com"
                  className="w-full rounded-2xl py-3 sm:py-3.5 pl-11 pr-4 text-sm sm:text-base outline-none transition-all border focus:ring-2"
                  style={{ backgroundColor: 'var(--input)', borderColor: 'var(--border)', color: 'var(--foreground)' }}
                  required
                  onChange={(e) => setLoginData({ ...loginData, username: e.target.value })}
                />
              </div>
            </div>

            <div className="space-y-1.5">
              <div className="flex justify-between items-center px-1">
                <label className="text-[10px] font-bold uppercase tracking-widest opacity-50">Password</label>
                <button type="button" className="text-[10px] font-bold uppercase tracking-widest hover:underline" style={{ color: 'var(--chart-1)' }}>
                  Forgot?
              </button>
              </div>
              <div className="relative group">
                <Lock className="absolute left-4 top-1/2 -translate-y-1/2 group-focus-within:opacity-100 transition-opacity" size={18} />
                <input
                  type="password"
                  placeholder="••••••••"
                  className="w-full rounded-2xl py-3 sm:py-3.5 pl-11 pr-4 text-sm sm:text-base outline-none transition-all border focus:ring-2"
                  style={{ backgroundColor: 'var(--input)', borderColor: 'var(--border)', color: 'var(--foreground)' }}
                  required
                  onChange={(e) => setLoginData({ ...loginData, password: e.target.value })}
                />
              </div>
            </div>

            {loading ?
              <button
                type="submit"
                disabled
                className="w-full py-3.5 sm:py-4 font-bold rounded-2xl transition-all hover:brightness-110 active:scale-[0.97] mt-2 shadow-lg text-sm sm:text-base"
                style={{
                  backgroundColor: 'var(--primary)',
                  color: 'var(--primary-foreground)',
                  display: 'flex',
                  alignItems: 'center',
                  justifyContent: 'center',
                  gap: '10px',
                  opacity: '0.7'
                }}


              >
                <Loader2 className="animate-spin" /> Signing in…
          </button> :
              <button
                type="submit"
                className="w-full py-3.5 sm:py-4 font-bold rounded-2xl transition-all hover:brightness-110 active:scale-[0.97] mt-2 shadow-lg text-sm sm:text-base"
                style={{ backgroundColor: 'var(--primary)', color: 'var(--primary-foreground)' }}
              >
                Sign In
          </button>

            }
          </form>

          {/* Footer */}
          <div className="mt-6 sm:mt-8 pt-6 border-t flex flex-col items-center gap-3 sm:gap-4" style={{ borderColor: 'var(--border)' }}>
            <p className="text-xs sm:text-sm" style={{ color: 'var(--muted-foreground)' }}>New here?</p>
            <button
              className="w-full py-3 rounded-2xl border text-xs sm:text-sm font-medium flex items-center justify-center gap-2 hover:bg-white/5 transition-all"
              style={{ borderColor: 'var(--border)', color: 'var(--foreground)' }}
            >
              <UserPlus size={16} />
            Create account
          </button>
          </div>
        </div>
      </div>
    </div>
  );
}