'use client';

import React, { useEffect, useState, useRef } from 'react';
import { getEngine } from '@/lib/engines';
import "@/styles/google-results.css"
import { useHistory } from '@/hooks/useHistory'
const { saveBrowserHistory } = useHistory();

interface GooglePagination {
    currentPage: number;
    totalPages: number;
}

function getGooglePagination(): GooglePagination | null {
    const pages = Array.from(
        document.querySelectorAll('.gsc-cursor-page')
    );

    if (pages.length === 0) return null;

    const currentIndex = pages.findIndex(page =>
        page.classList.contains('gsc-cursor-current-page')
    );

    return {
        currentPage: currentIndex + 1,
        totalPages: pages.length,
    };
}


function goToGooglePage(pageNumber: number) {
    const pages = Array.from(
        document.querySelectorAll('.gsc-cursor-page')
    );

    const page = pages[pageNumber - 1] as HTMLElement | undefined;
    if (page) page.click();
}

const delay = (ms) => new Promise(resolve => setTimeout(resolve, ms));

function injectCSEInlineStyles(styles = {
    backgroundColor: 'transparent',
    padding: '0 !important',
    margin: '0',
    border: 'none',
    boxShadow: 'none',
    width: '100%',

}) {
    const circleStyle = {
        background: 'var(--secondary)',
        color: 'white',
        width: '30px',
        height: '30px',
        borderRadius: '50%',
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center',
    }


    const selector = '.gsc-control-cse, .gsc-control-cse-en';


    const applyStyles = () => {
        const el = document.querySelector(selector);
        if (!el) return false;

        Object.assign(el.style, styles);
        return true;
    };
    applyStyles()
    document.querySelectorAll('.gsc-webResult .gsc-result').forEach(el => el.style.border = 'none')
    document.querySelectorAll('.gsc-cursor-current-page').forEach(el => {
        Object.assign(el.style, circleStyle)
    })


    document.querySelectorAll('.gsc-cursor-box').forEach(el => el.style.width = '100%')

    const nextBtn = document.querySelectorAll('.gsc-cursor-container-next')

    nextBtn.forEach(el => {

        el.innerHTML = "Load More"
        Object.assign(
            el.style, {
            justifyContent: 'center',
            background: 'var(--secondary)',
            borderRadius: '50px'
        })
    })

    document.querySelectorAll('.gsc-cursor-container-previous, .gsc-cursor-next-page').forEach(el => el.style.display = 'none')
    document.querySelectorAll('.gsc-cursor-numbered-page').forEach(el => el.style.display = 'none')


    const currentPages = document.querySelectorAll(
        '.gsc-cursor-page.gsc-cursor-current-page'
    );

    if (!currentPages) {
        console.log('Current page not found');
    } else {

        currentPages.forEach(currentPage => {
            const nextPage = currentPage.nextElementSibling;

            if (nextPage?.classList.contains('gsc-cursor-page')) {
                nextPage.innerText = "Load More"
                Object.assign(
                    nextPage.style, {
                    justifyContent: 'center',
                    background: 'var(--secondary)',
                    borderRadius: '50px',
                    display: 'block',
                    color: 'white',
                    padding: '10px 20px'
                })
                nextPage.style.setProperty('display', 'block', 'important');
                nextPage.classList.add('force-block');

                const cursorBox = document.querySelector('.gsc-cursor-box');
                // if (!cursorBox) return;

            } else {
                console.log('No next page available');
            }


        })


    }

    const alltPages = document.querySelectorAll(
        '.gsc-cursor-page'
    ).forEach(el => {
        if (el.classList.contains('force-block')) {

        } else {

            el.style.display = "none"
        }
    });



}
interface WebSearchResultsProps {
    query: string;
}

function getFaviconFromUrl(url) {
    try {
        const domain = new URL(url).hostname;
        return `https://www.google.com/s2/favicons?domain=${domain}&sz=64`;
    } catch {
        return '';
    }
}

function getGSImageSrc(result) {
    if (!result) return '';

    const gsImage = result.querySelector('.gs-image');
    if (!gsImage) return '';

    // Case 1: <img src="...">
    const img = gsImage.querySelector('img');
    if (img?.src) {
        return img.src;
    }

    // Case 2: background-image: url(...)
    //   const bg = window.getComputedStyle(gsImage).backgroundImage;
    //   if (bg && bg !== 'none') {
    //     const match = bg.match(/url\(["']?(.*?)["']?\)/);
    //     return match ? match[1] : null;
    //   }

    return '';
}


function getWebSearchResults() {
    const wrapper = document.querySelector('.google-search-wrapper');
    if (!wrapper) return [];

    const results = Array.from(
        wrapper.querySelectorAll('.gsc-webResult.gsc-result')
    );

    return results.map(result => {
        // Title + Link
        const titleAnchor =
            result.querySelector('.gs-title a') ||
            result.querySelector('a.gs-title');

        const title = titleAnchor?.textContent?.trim() || '';
        const link = titleAnchor?.href || '';

        // Description / snippet
        const snippet =
            result.querySelector('.gs-snippet')?.textContent?.trim() ||
            result.querySelector('.gs-bidi-start-align')?.textContent?.trim() ||
            '';

        // Display URL (green link style)
        const displayUrl =
            result.querySelector('.gs-visibleUrl')?.textContent?.trim() ||
            result.querySelector('.gsc-url-top')?.textContent?.trim() ||
            '';

        // Site name (sometimes present)
        const siteName =
            result.querySelector('.gs-site-name')?.textContent?.trim() ||
            '';

        // Favicon (Google usually embeds it as img)
        const domFavicon =
            result.querySelector('img[src*="favicon"]')?.src ||
            result.querySelector('img')?.src ||
            '';

        const favicon = domFavicon || getFaviconFromUrl(link);

        // Time / date (if Google provides it)
        // Often appears like: "2 days ago", "Jan 12, 2025"
        const time =
            result.querySelector('.gs-age')?.textContent?.trim() ||
            result.querySelector('.f')?.textContent?.trim() ||
            '';

        const thumbnail = getGSImageSrc(result) || ''
        // console.log(result.querySelector('.gs-image'))
        return {
            title,
            link,
            snippet,
            displayUrl,
            siteName,
            favicon,
            time,
            thumbnail
        };
    });
}

// function getGooglePaginationElement(): HTMLElement | null {
//     const pagination = document.querySelector('.gsc-cursor-box');
//     if (!pagination) return null;

//     return pagination.cloneNode(true) as HTMLElement;
// }
function getGooglePaginationElement(): HTMLElement | null {
    // return document.querySelector('.gsc-cursor-box') as HTMLElement | null;

    const nodes = document.querySelectorAll('.gsc-cursor-box');
    // console.log(nodes)
    return nodes.length
        ? (nodes[nodes.length - 1] as HTMLElement)
        : null;

}

export interface GoogleSearchResult {
    title: string;
    link: string;
    snippet: string;
    displayUrl: string;
    siteName: string;
    favicon: string;
    time: string;
    thumbnail: string;
}

function seedWebsites(websites) {

    try {
        fetch("/api/websites-bulk-submit", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "x-admin-key": process.env.NEXT_PUBLIC_ADMIN_KEY!,
            },
            body: JSON.stringify({ websites }),

        })
    } catch (e) {

    }
}
const GoogleWebSearchResults: React.FC<WebSearchResultsProps> = ({ query, setTotalResultCount }) => {
    const [loading, setLoading] = useState(false);
    const [googleResults, setGoogleResults] = useState<GoogleSearchResult[]>([]);
    const [pagination, setPagination] = useState<GooglePagination | null>(null);
    const [paginationEl, setPaginationEl] = useState<HTMLElement | null>(null);
    const paginationContainerRef = useRef<HTMLDivElement | null>(null);
    const [pageUpdate, setPageUpdate] = useState(1)
    const observerRef = useRef<MutationObserver | null>(null);

    const prevContainerRef = useRef<HTMLDivElement | null>(null);
    const [resultNumber, setResultNumber] = useState('')
    // const paginationContainerRef = useRef<HTMLDivElement | null>(null);
    const nextContainerRef = useRef<HTMLDivElement | null>(null);
    const [showGoogle, setShowGoogle] = useState(true)

    const engine = getEngine('web');
    // console.log(query)

    useEffect(() => {
        console.log("inside result change")
        const wrapper = document.querySelector('.google-search-wrapper');
        if (!wrapper) {
            setLoading(false)
            // setShowGoogle(true)
            return;
        }

        let hasRun = false;

        const observer = new MutationObserver(async () => {
            if (hasRun) return;
            setLoading(true)
            // await delay(3000);
            const results = getWebSearchResults();

            injectCSEInlineStyles()
            if (results.length > 0) {
                // console.log(results)
                // const pagination = getGooglePaginationElement();
                // console.log(pagination)
                setShowGoogle(false)
                setLoading(false)
                setGoogleResults([...googleResults, ...results]);

                setResultNumber(document.getElementsByClassName('gsc-result-info')[0].innerHTML || '')
                try{
                    setTotalResultCount(document.getElementsByClassName('gsc-result-info')[0].innerHTML || '')
                }catch(e){}
                hasRun = true;
                observer.disconnect();
                seedWebsites(results)

            }
            setLoading(false)
        });

        // setLoading(false)
        observer.observe(wrapper, { childList: true, subtree: true });

        return () => observer.disconnect();
    }, [pageUpdate]);


    // useEffect(() => {
    //     const wrapper = document.querySelector('.google-search-wrapper');
    //     if (!wrapper) return;

    //     let moved = false;

    //     const observer = new MutationObserver(() => {
    //         if (moved) return;

    //         const pagination = getGooglePaginationElement();
    //         // if (pagination && paginationContainerRef.current)
    //         if (pagination && paginationContainerRef.current) {
    //             paginationContainerRef.current.appendChild(pagination);
    //             moved = true;
    //             setPageUpdate(pageUpdate + 1)
    //             observer.disconnect();
    //         }
    //     });

    //     observer.observe(wrapper, { childList: true, subtree: true });

    //     return () => observer.disconnect();
    // }, [pageUpdate]);


    useEffect(() => {
        const wrapper = document.querySelector('.google-search-wrapper');
        if (!wrapper) return;

        const observer = new MutationObserver(() => {
            const pagination = getGooglePaginationElement();
            const container = paginationContainerRef.current;
            // console.log(pagination)
            setPageUpdate(pageUpdate + 1)
            if (
                pagination &&
                container &&
                !container.contains(pagination)
            ) {

                container.innerHTML = '';

                container.appendChild(pagination);
                observer.disconnect();
            }
        });

        observer.observe(wrapper, {
            childList: true,
            subtree: true,
        });

        return () => observer.disconnect();
    }, [pageUpdate]);







    useEffect(() => {
        if (!query) return;

        setLoading(true);

        const old = document.getElementById('google-cse-web');
        if (old) old.remove();

        const script = document.createElement('script');
        script.id = 'google-cse-web';
        script.async = true;
        script.src = `https://cse.google.com/cse.js?cx=${engine.cx}`;
        script.onload = () => setLoading(false);

        document.body.appendChild(script);

    }, [engine.cx, query]);


    useEffect(() => {
        if (!loading) {
            // window.scrollTo({ top: 0, behavior: 'smooth' });
        }
    }, [googleResults]);



    return (
        <div>
            { googleResults && <div className="text-sm text-muted-foreground mb-6">{resultNumber}</div>}
            <div>{googleResults &&

                googleResults.map((result, index) => (
                    ((result.siteName || result.link) && <div key={index} className="mb-8 w-full">
                        {/* Top row */}
                        <div className="flex items-start gap-3 mb-1">
                            {/* Favicon */}
                            <div className="flex-shrink-0 mt-1">
                                <img
                                    src={result.favicon}
                                    alt={result.siteName || result.title}
                                    className="w-5 h-5 rounded-sm"
                                    onError={(e) => {
                                        e.currentTarget.src = "/placeholder.svg?height=20&width=20";
                                    }}

                                    style={{
                                        borderRadius: '50%'
                                    }}
                                />
                            </div>

                            {/* Site info */}
                            <div className="flex-1 min-w-0">
                                <div className="flex items-center gap-2 mb-1">
                                    <span className="text-sm font-medium text-foreground truncate">
                                        {result.siteName || result.link || ''}
                                    </span>

                                    {/* Optional badge */}
                                    {result.siteName && (
                                        <span className="text-xs text-muted-foreground">• Official</span>
                                    )}
                                </div>

                                {/* Display URL */}
                                <div className="text-sm text-green-700 dark:text-green-400 mb-1 truncate">
                                    {result.displayUrl || result.link || ''}
                                </div>
                            </div>
                        </div>

                        {/* Title */}
                        <div style={{
                            display: 'flex',
                            gap: '10px',
                            justifyContent: 'space-between'
                        }}>
                            <div>
                                <h3 className="mb-2">
                                    <a
                                        href={result.link}
                                        target="_blank"
                                        rel="noopener noreferrer"
                                        className="text-lg sm:text-xl text-blue-600 dark:text-blue-400 hover:underline font-normal leading-tight"
                                        onClick={() => saveBrowserHistory(
                                            {
                                                url: result.link,
                                                title: result.title,
                                                source: "search",

                                            }
                                        )}
                                    >
                                        {result.title}
                                    </a>
                                </h3>

                                {/* Description */}
                                <p className="text-sm text-foreground leading-relaxed mb-2 max-w-full">
                                    {result.snippet}
                                </p>

                                {/* Extra links (optional future use) */}
                                <div className="flex flex-wrap gap-3 text-sm">
                                    <a
                                        href={result.link}
                                        target="_blank"
                                        rel="noopener noreferrer"
                                        className="text-blue-600 dark:text-blue-400 hover:underline capitalize text-xs"
                                    >
                                        Visit site
      </a>
                                </div>
                            </div>
                            {result.thumbnail && <div
                                style={{
                                    aspectRatio: '1 / 1',
                                    borderRadius: '10px',
                                    height: '100px'
                                }}
                            >
                                <img src={result.thumbnail} alt="thumbnail" style={{
                                    aspectRatio: '1 / 1',
                                    borderRadius: '10px',
                                    width: '100%',
                                    height: '100%',
                                    objectFit: 'cover'
                                }} />
                            </div>}

                            {/* Time */}
                            {result.time && (
                                <div className="text-xs text-muted-foreground mt-2">
                                    {result.time}
                                </div>
                            )}
                        </div>

                    </div>)
                ))

            }



                <div>

                    {loading &&

                        <div className="flex items-center justify-center py-12">
                            <div className="animate-spin rounded-full h-8 w-8 border-b-2 border-accent"></div>
                        </div>

                    }

                </div>


                <div
                    ref={paginationContainerRef}
                    className="mt-8 flex justify-center lg:justify-start"
                ></div>
                {/* <div>
    {pageUpdate}
</div> */}
                {/* 
                <div className="flex justify-between items-center mt-8 gap-4">
                    <div ref={prevContainerRef} />
                    <div ref={paginationContainerRef} className="flex gap-2" />
                    <div ref={nextContainerRef} />
                </div> */}


            </div>



            <div className="google-search-wrapper"
                style={{
                    backgroundColor: "transparent",
                    padding: 0,
                    margin: 0,
                    display: showGoogle ? 'block' : 'none',
                    opacity: showGoogle ? 1 : 0
                }}
            >
                <div className="gcse-searchresults-only"
                    data-enableimagesearch="false"
                    data-defaulttoimagesearch="false"
                    data-linktarget="_blank"

                    style={{
                        backgroundColor: "transparent"
                    }}

                />
            </div>


        </div>
    );
};

// export default GoogleWebSearchResults;
export default React.memo(GoogleWebSearchResults, (prev, next) => {
    return prev.value === next.value;
})
