'use client';

import { ENGINES, EngineType } from '@/lib/engines';
import { useRouter, useSearchParams } from 'next/navigation';

export default function SearchTabs() {
  const router = useRouter();
  const params = useSearchParams();
  const q = params.get('q') || '';
  const active = (params.get('type') as EngineType) || 'web';

  return (
    <div className="flex gap-6 border-b mb-4">
      {ENGINES.map(engine => (
        <button
          key={engine.id}
          onClick={() =>
            router.push(`/google-search?q=${encodeURIComponent(q)}&type=${engine.id}`)
          }
          className={`pb-2 ${
            active === engine.id
              ? 'border-b-2 border-blue-600 font-semibold'
              : 'text-gray-500'
          }`}
        >
          {engine.label}
        </button>
      ))}
    </div>
  );
}
