// components/FullscreenPopup.tsx
import { Portal } from "./Portal";

export function FullscreenPopup({ onClose }: { onClose: () => void }) {
  return (
    <Portal>
      <div className="fixed inset-0 z-[9999] bg-black/80 backdrop-blur-lg">
        <button
          onClick={onClose}
          className="absolute top-4 right-4 text-white"
        >
          ✕
        </button>

        <div className="h-full flex items-center justify-center text-white">
          Fullscreen Popup Content
        </div>
      </div>
    </Portal>
  );
}
