import React from 'react';
import Link from 'next/link';

const Footer = () => {
  return (
    // <footer className="w-full bg-[var(--background)] border-t border-[var(--border)] pt-16 pb-8 px-6 font-sans">

    <footer className="w-full bg-[var(--background)]  pt-16 pb-8 px-6 font-sans ">
      {/* min-[1200px]:pl-[130px] */}
      {/* <div className="max-w-7xl mx-auto"> */}
      <div className="w-full">

        {/* <div className="grid grid-cols-1 md:grid-cols-4 gap-12 mb-16">
          
          
          <div className="col-span-1 md:col-span-1">
            <div className="flex items-center gap-2 mb-4">
              <div className="h-6 w-6 rounded-full bg-[var(--primary)]" />
              <span className="text-[var(--foreground)] font-bold text-xl tracking-tight">Search.ai</span>
            </div>
            <p className="text-[var(--muted-foreground)] text-sm leading-relaxed">
              Experience the next generation of search with real-time intelligence and privacy-first indexing.
            </p>
          </div>

        
          <div>
            <h4 className="text-[var(--foreground)] font-medium mb-4 text-sm">Product</h4>
            <ul className="space-y-2 text-sm text-[var(--muted-foreground)]">
              <li><a href="#" className="hover:text-[var(--primary)] transition-colors">Search</a></li>
              <li><a href="#" className="hover:text-[var(--primary)] transition-colors">Extensions</a></li>
              <li><a href="#" className="hover:text-[var(--primary)] transition-colors">Mobile App</a></li>
            </ul>
          </div>

          <div>
            <h4 className="text-[var(--foreground)] font-medium mb-4 text-sm">Resources</h4>
            <ul className="space-y-2 text-sm text-[var(--muted-foreground)]">
              <li><a href="#" className="hover:text-[var(--primary)] transition-colors">Documentation</a></li>
              <li><a href="#" className="hover:text-[var(--primary)] transition-colors">API Reference</a></li>
              <li><a href="#" className="hover:text-[var(--primary)] transition-colors">Community</a></li>
            </ul>
          </div>

     
          <div className="bg-[var(--sidebar)] border border-[var(--sidebar-border)] p-6 rounded-2xl relative overflow-hidden group">
     
            <div className="absolute top-0 left-0 w-full h-[1px] bg-gradient-to-r from-transparent via-[var(--sidebar-primary)] to-transparent opacity-50 group-hover:via-[var(--primary)] transition-all duration-500" />
            
            <h4 className="text-[var(--sidebar-foreground)] font-medium mb-2 text-sm">System Status</h4>
            <div className="flex items-center gap-2 mb-4">
              <span className="h-2 w-2 rounded-full bg-emerald-500 animate-pulse" />
              <span className="text-xs text-[var(--muted-foreground)]">All systems operational</span>
            </div>
            <button className="w-full py-2 bg-[var(--primary)] text-[var(--primary-foreground)] rounded-lg text-xs font-semibold hover:opacity-90 transition-opacity">
              Download Beta
            </button>
          </div>
        </div> */}

        {/* Bottom Bar */}
        <div className="pt-8 border-t border-[var(--border)] flex flex-col md:flex-row justify-between items-center gap-4">
          <div className="text-[var(--muted-foreground)] text-xs flex gap-6 text-center">
            <span>© {new Date().getFullYear()} Indzs Search.</span>
            {/* <a href="/privacy-policy" className="hover:underline">Privacy Policy</a> */}
            {/* <a href="/terms-of-service" className="hover:underline">Terms of Service</a> */}
            {/* Privacy Link */}
            <Link href="/privacy" className="relative group overflow-hidden">
              <span className="group-hover:text-[var(--foreground)] transition-colors duration-300">
                Privacy Policy
    </span>
              <span className="absolute bottom-0 left-0 w-full h-[1px] bg-[var(--primary)] translate-x-[-100%] group-hover:translate-x-0 transition-transform duration-300" />
            </Link>

            {/* Terms Link */}
            <Link href="/terms" className="relative group overflow-hidden">
              <span className="group-hover:text-[var(--foreground)] transition-colors duration-300">
                Terms of Service
    </span>
              <span className="absolute bottom-0 left-0 w-full h-[1px] bg-[var(--primary)] translate-x-[-100%] group-hover:translate-x-0 transition-transform duration-300" />
            </Link>

          </div>

          <div className="flex items-center gap-4">
            {/* Social Icons Placeholder */}
            <div className="h-8 w-8 rounded-lg bg-[var(--secondary)] border border-[var(--border)] flex items-center justify-center hover:bg-[var(--accent)] transition-colors cursor-pointer">
              <div className="w-4 h-4 bg-[var(--foreground)] rounded-sm opacity-70" />
            </div>
            <div className="h-8 w-8 rounded-lg bg-[var(--secondary)] border border-[var(--border)] flex items-center justify-center hover:bg-[var(--accent)] transition-colors cursor-pointer">
              <div className="w-4 h-4 bg-[var(--foreground)] rounded-full opacity-70" />
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
};

export default Footer;