"use client"

import { useState } from "react"
import { LinkItem } from "./QuickLinks"
import "@/styles/dialog.css"
export default function AddWebsiteModal({
  onClose,
  onAdd,
}: {
  onClose: () => void
  onAdd: (site: LinkItem) => void
}) {
  const [url, setUrl] = useState("")
  const [name, setName] = useState("")
  const [error, setError] = useState("");
  const handleAdd = () => {
    try {
      const parsed = new URL(url)
      const domain = parsed.hostname

      const newSite: LinkItem = {
        id: domain,
        name: name || domain.replace("www.", ""),
        url,
        favicon: `https://www.google.com/s2/favicons?domain=${domain}&sz=64`,
        visits: 0,
        color: generatePastel(),
      }

      onAdd(newSite)
      onClose()
    } catch {
      // alert("Invalid URL")
      setError("Please enter a valid URL");
    }
  }

  return (
    <div className="add-web-overlay">
  <div className="add-web-container">
    {/* Close Icon */}
    <button className="add-web-close-btn" onClick={onClose}>×</button>
    
    <div className="add-web-header">
      <h2 className="add-web-title">Add Website</h2>
      <p className="add-web-subtext">
        Enter the details of the website you'd like to add on your profile.
      </p>
    </div>

    {/* Alert Section */}
    {error && (
      <div className="add-web-alert">
        <span className="add-web-alert-icon">⚠️</span>
        <span className="add-web-alert-msg">{error}</span>
      </div>
    )}

    <div className="add-web-field-group">
      <label className="add-web-label">Name</label>
      <input
        className="add-web-input"
        placeholder="e.g. Portfolio"
        value={name}
        onChange={(e) => setName(e.target.value)}
      />
    </div>

    <div className="add-web-field-group">
      <label className="add-web-label">URL</label>
      <input
        className="add-web-input"
        placeholder="https://example.com"
        value={url}
        onChange={(e) => setUrl(e.target.value)}
      />
    </div>

    <div className="add-web-footer">
      <button className="add-web-btn-cancel" onClick={onClose}>
        Cancel
      </button>
      <button className="add-web-btn-submit" onClick={handleAdd}>
        Add website
      </button>
    </div>
  </div>
</div>
  )
}

/* Random pastel background */
function generatePastel() {
  const colors = [
    "#FFECEC",
    "#ECFDF3",
    "#EEF2FF",
    "#FFF7ED",
    "#F3E8FF",
    "#ECFEFF",
  ]
  return colors[Math.floor(Math.random() * colors.length)]
}
