"use client"

import { useState } from "react"
import Link from "next/link"
import { usePathname } from "next/navigation"
import { cn } from "@/lib/utils"
import { Button } from "@/components/ui/button"
import {
  LayoutDashboard,
  Globe,
  ImageIcon,
  Settings,
  Menu,
  X,
  Search,
  Megaphone,
  BarChart3,
  Plus,
  Users,
} from "lucide-react"

const navigation = [
  { name: "Dashboard", href: "/webadmin/dashboard", icon: LayoutDashboard },
  { name: "Web Results", href: "/webadmin/web", icon: Globe },
  { name: "Image Results", href: "/webadmin/images", icon: ImageIcon },
  { name: "Websites", href: "/webadmin/websites", icon: Plus },
  { name: "Users", href: "/webadmin/users", icon: Users },
  { name: "Ads Management", href: "/webadmin/ads", icon: Megaphone },
  { name: "User Ads", href: "/webadmin/user-ads", icon: Search },
  { name: "Ad Analytics", href: "/webadmin/analytics", icon: BarChart3 },
  { name: "Settings", href: "/webadmin/settings", icon: Settings },
]

export function AdminSidebar() {
  const [isCollapsed, setIsCollapsed] = useState(false)
  const pathname = usePathname()

  return (
    <div
      className={cn(
        "bg-sidebar border-r border-sidebar-border transition-all duration-300",
        isCollapsed ? "w-16" : "w-64",
      )}
    >
      <div className="flex h-full flex-col">
        {/* Header */}
        <div className="flex items-center justify-between p-4 border-b border-sidebar-border">
          {!isCollapsed && (
            <div className="flex items-center space-x-2">
              <Search className="h-6 w-6 text-primary" />
              <span className="font-bold font-playfair text-lg text-sidebar-foreground">IndusSearch</span>
            </div>
          )}
          <Button
            variant="ghost"
            size="sm"
            onClick={() => setIsCollapsed(!isCollapsed)}
            className="text-sidebar-foreground hover:bg-sidebar-primary"
          >
            {isCollapsed ? <Menu className="h-4 w-4" /> : <X className="h-4 w-4" />}
          </Button>
        </div>

        {/* Navigation */}
        <nav className="flex-1 p-4 space-y-2">
          {navigation.map((item) => {
            const isActive = pathname === item.href
            return (
              <Link
                key={item.name}
                href={item.href}
                className={cn(
                  "flex items-center space-x-3 px-3 py-2 rounded-lg text-sm font-medium transition-colors",
                  isActive
                    ? "bg-sidebar-accent text-sidebar-accent-foreground"
                    : "text-sidebar-foreground hover:bg-sidebar-primary hover:text-sidebar-primary-foreground",
                  isCollapsed && "justify-center",
                )}
              >
                <item.icon className="h-5 w-5 flex-shrink-0" />
                {!isCollapsed && <span>{item.name}</span>}
              </Link>
            )
          })}
        </nav>

        {/* Footer */}
        <div className="p-4 border-t border-sidebar-border">
          <div className={cn("text-xs text-muted-foreground", isCollapsed ? "text-center" : "")}>
            {!isCollapsed && "Admin Panel v1.0"}
          </div>
        </div>
      </div>
    </div>
  )
}
