"use client"

import { Button } from "@/components/ui/button"
import { Bell, User } from "lucide-react"
import { useState } from "react"
import { useAdminAuth } from "./admin-auth-provider"
import { AdminUserDialog } from "./admin-user-dialog"

export function AdminHeader() {
  const { admin } = useAdminAuth()
  const [isProfileOpen, setIsProfileOpen] = useState(false)

  return (
    <>
      <header className="bg-card border-b border-border px-6 py-4">
        <div className="flex items-center justify-between">
          <div>
            <h2 className="text-lg font-semibold text-card-foreground">Admin Panel</h2>
          </div>

          <div className="flex items-center space-x-4">
            <Button variant="ghost" size="sm">
              <Bell className="h-4 w-4" />
            </Button>

            <Button variant="ghost" size="sm" onClick={() => setIsProfileOpen(true)}>
              <User className="h-4 w-4" />
              {admin && <span className="ml-2 text-sm">{admin.username}</span>}
            </Button>
          </div>
        </div>
      </header>

      <AdminUserDialog isOpen={isProfileOpen} onClose={() => setIsProfileOpen(false)} />
    </>
  )
}
