"use client";

import 'regenerator-runtime/runtime';
import React, { useEffect, useState } from 'react';
import SpeechRecognition, { useSpeechRecognition } from 'react-speech-recognition';
import { Mic, MicOff, Search, RefreshCw } from 'lucide-react';

const VoiceSearchBox = ({onChange}) => {
    const [silenceTimeout, setSilenceTimeout] = useState<NodeJS.Timeout | null>(null);
    const [isMounted, setIsMounted] = useState(false);
    const {
        transcript,
        listening,
        resetTranscript,
        browserSupportsSpeechRecognition
    } = useSpeechRecognition();



    // 1. Monitor transcript changes to reset the "Silence Timer"
    useEffect(() => {
        if (listening) {
            // Clear existing timer whenever the user speaks (transcript changes)
            if (silenceTimeout) clearTimeout(silenceTimeout);

            // Set a new timer: If 3 seconds pass without new words, stop listening
            const timer = setTimeout(() => {
                SpeechRecognition.stopListening();
                console.log("Auto-stopped due to silence.");
                console.log(transcript)
                if(transcript){
                    onChange(transcript)
                }
                // Optional: Trigger search function here
                // handleSearch(transcript); 
            }, 3000); // 3 seconds of silence

            setSilenceTimeout(timer);
        }

        return () => {
            if (silenceTimeout) clearTimeout(silenceTimeout);
        };
    }, [transcript, listening]);

    const toggleListening = () => {
        if (listening) {
            SpeechRecognition.stopListening();
        } else {
            resetTranscript();
            SpeechRecognition.startListening({
                continuous: true,
                language: navigator.language
            });
        }
    };
    // Handle Hydration for Next.js
    useEffect(() => {
        setIsMounted(true);
    }, []);

    if (!isMounted) return null;

    if (!browserSupportsSpeechRecognition) {
        // return <p>Your browser does not support speech recognition.</p>;
    }

    const handleStart = () => {
        // Advanced: Auto-detects based on browser language (e.g., 'en-US', 'es-ES')
        const userLang = navigator.language || 'en-US';
        SpeechRecognition.startListening({
            continuous: true,
            language: userLang
        });
    };

    return (

        <button
            //             // onClick={listening ? SpeechRecognition.stopListening : handleStart}
            onClick={toggleListening}
            className={` p-2 rounded-full flex justify-center text-center w-[40px] h-[40px] transition-colors ${listening ? 'bg-red-500 text-white animate-pulse' : ''
                }`}

                style={{
                    alignItems:'center'
                }}
        >
            {listening ? <MicOff size={20} /> : <Mic size={20} />}
        </button>



        // <div className="flex flex-col items-center w-full max-w-md mx-auto p-4 space-y-4">
        //     <div className="relative w-full">
        //         <input
        //             type="text"
        //             value={transcript}
        //             placeholder="Speak to search..."
        //             className="w-full pl-10 pr-12 py-3 border-2 border-gray-200 rounded-full focus:border-blue-500 outline-none transition-all"
        //             readOnly
        //         />
        //         <Search className="absolute left-3 top-3.5 text-gray-400" size={20} />


        //     </div>

        //     <div className="flex space-x-2">
        //         <button
        //             onClick={resetTranscript}
        //             className="text-xs text-gray-500 flex items-center gap-1 hover:text-gray-800"
        //         >
        //             <RefreshCw size={12} /> Clear
        // </button>
        //         <span className="text-xs text-gray-400">
        //             Detected Lang: {navigator.language}
        //         </span>
        //     </div>

        //     {listening && (
        //         <div className="text-sm text-blue-500 font-medium">
        //             Listening... try saying "Latest tech news"
        //         </div>
        //     )}
        // </div>
    );
};

export default VoiceSearchBox;