import React from 'react';
import Footer from '@/components/ui/Footer';         // The footer we built earlier
import Header from '@/components/ui/Header';  
/**
 * PROPS:
 * data: The JSON object containing title, lastUpdated, and sections.
 */
const LegalTemplate = ({ data }) => {
  if (!data) return null;

  return (
    <div className="min-h-screen bg-[var(--background)] text-[var(--foreground)] selection:bg-[var(--primary)] selection:text-[var(--primary-foreground)]">
      <Header/>
      {/* Background Aesthetic Gradients */}
      <div className="fixed inset-0 overflow-hidden pointer-events-none">
        <div className="absolute top-[-10%] left-[-10%] w-[40%] h-[40%] bg-[var(--chart-1)] rounded-full blur-[120px] opacity-[0.05]" />
        <div className="absolute bottom-[10%] right-[-10%] w-[30%] h-[30%] bg-[var(--chart-4)] rounded-full blur-[120px] opacity-[0.05]" />
      </div>

      <main className="relative max-w-6xl mx-auto px-6 pt-32 pb-24">
        {/* Header Section */}
        <header className="mb-16 border-b border-[var(--border)] pb-8">
          <h1 className="text-4xl md:text-6xl font-bold tracking-tight mb-6 bg-gradient-to-b from-[var(--foreground)] to-[var(--muted-foreground)] bg-clip-text text-transparent">
            {data.title}
          </h1>
          <div className="flex items-center gap-4">
            <div className="px-3 py-1 rounded-full bg-[var(--secondary)] border border-[var(--border)] text-[10px] uppercase tracking-widest font-bold text-white">
              Legal Document
            </div>
            <p className="text-[var(--muted-foreground)] text-sm">
              Last updated: <span className="text-[var(--foreground)]">{data.lastUpdated}</span>
            </p>
          </div>
        </header>

        <div className="flex flex-col md:flex-row gap-16">
          {/* Auto-Generating Sidebar */}
          <aside className="md:w-64 flex-shrink-0">
            <nav className="sticky top-32 space-y-6">
              <div>
                <p className="text-[var(--primary)] font-bold text-[10px] uppercase tracking-[0.2em] mb-4">Contents</p>
                <ul className="space-y-3 text-sm">
                  {data.sections.map((section) => (
                    <li key={section.id}>
                      <a 
                        href={`#${section.id}`} 
                        className="text-[var(--muted-foreground)] hover:text-[var(--foreground)] transition-all duration-300 hover:pl-1 block"
                      >
                        {section.heading.split('. ')[1] || section.heading}
                      </a>
                    </li>
                  ))}
                </ul>
              </div>
              
              <div className="pt-6 border-t border-[var(--border)]">
                <button className="text-xs text-[var(--muted-foreground)] hover:text-[var(--primary)] flex items-center gap-2 group">
                  <span>Download PDF</span>
                  <div className="w-4 h-4 rounded bg-[var(--secondary)] group-hover:bg-[var(--primary)] transition-colors" />
                </button>
              </div>
            </nav>
          </aside>

          {/* Content Loop */}
          <article className="flex-1 max-w-3xl">
            {data.sections.map((section) => (
              <section key={section.id} id={section.id} className="mb-16 scroll-mt-32">
                <h2 className="text-2xl font-semibold mb-6 text-[var(--foreground)] flex items-center gap-3">
                  <span className="text-[var(--muted-foreground)] font-mono text-sm uppercase tracking-tighter">
                    [{section.id.substring(0, 2)}]
                  </span>
                  {section.heading}
                </h2>
                
                <p className="text-[var(--muted-foreground)] leading-relaxed mb-6 text-lg">
                  {section.content}
                </p>

                {section.list && (
                  <ul className="space-y-4 mb-6">
                    {section.list.map((item, idx) => (
                      <li key={idx} className="flex gap-3 text-[var(--muted-foreground)]">
                        <span className="text-[var(--primary)] mt-1.5">•</span>
                        <span>{item}</span>
                      </li>
                    ))}
                  </ul>
                )}

                {section.highlight && (
                  <div className="p-6 rounded-2xl bg-[var(--sidebar)] border border-[var(--sidebar-border)] relative overflow-hidden group">
                    <div className="absolute top-0 left-0 w-1 h-full bg-[var(--primary)]" />
                    <p className="text-sm text-[var(--sidebar-foreground)] italic leading-relaxed">
                      {section.highlight}
                    </p>
                  </div>
                )}
              </section>
            ))}
          </article>
        </div>
      </main>
      <Footer/>
    </div>
  );
};

export default LegalTemplate;