import React from 'react';

const LegalPage = ({ title, lastUpdated, children }) => {
  return (
    <div className="min-h-screen bg-[var(--background)] text-[var(--foreground)] selection:bg-[var(--primary)] selection:text-[var(--primary-foreground)]">
      {/* Subtle Background Glow */}
      <div className="fixed top-0 left-1/2 -translate-x-1/2 w-full h-full max-w-6xl opacity-[0.03] pointer-events-none">
        <div className="absolute top-[-10%] left-[-10%] w-[40%] h-[40%] bg-[var(--chart-1)] rounded-full blur-[120px]" />
        <div className="absolute bottom-[10%] right-[-10%] w-[30%] h-[30%] bg-[var(--chart-4)] rounded-full blur-[120px]" />
      </div>

      <main className="relative max-w-5xl mx-auto px-6 pt-32 pb-24">
        {/* Header Section */}
        <header className="mb-16 border-b border-[var(--border)] pb-8">
          <h1 className="text-4xl md:text-5xl font-bold tracking-tight mb-4">
            {title}
          </h1>
          <p className="text-[var(--muted-foreground)] text-sm">
            Last updated: <span className="text-[var(--foreground)]">{lastUpdated}</span>
          </p>
        </header>

        <div className="flex flex-col md:flex-row gap-16">
          {/* Sticky Sidebar Navigation */}
          <aside className="md:w-64 flex-shrink-0">
            <nav className="sticky top-32 space-y-4">
              <p className="text-[var(--primary)] font-semibold text-xs uppercase tracking-widest">Contents</p>
              <ul className="space-y-3 text-sm text-[var(--muted-foreground)]">
                <li className="hover:text-[var(--foreground)] cursor-pointer transition-colors">Introduction</li>
                <li className="hover:text-[var(--foreground)] cursor-pointer transition-colors">Data Collection</li>
                <li className="hover:text-[var(--foreground)] cursor-pointer transition-colors">Usage Rights</li>
                <li className="hover:text-[var(--foreground)] cursor-pointer transition-colors">Security</li>
                <li className="hover:text-[var(--foreground)] cursor-pointer transition-colors">Contact Us</li>
              </ul>
            </nav>
          </aside>

          {/* Content Area */}
          <article className="prose prose-invert max-w-none prose-headings:text-[var(--foreground)] prose-p:text-[var(--muted-foreground)] prose-li:text-[var(--muted-foreground)] prose-strong:text-[var(--foreground)] prose-border-[var(--border)]">
            <section className="mb-12">
              <h2 className="text-2xl font-semibold mb-4">1. Overview</h2>
              <p className="leading-relaxed mb-4">
                Welcome to Animate-UI. We respect your privacy and are committed to protecting your personal data. 
                This document will inform you as to how we look after your personal data when you visit our website 
                and tell you about your privacy rights and how the law protects you.
              </p>
              <div className="p-4 rounded-xl bg-[var(--secondary)] border border-[var(--border)] text-sm italic">
                Quick Summary: We prioritize your anonymity and do not track individual users across the web.
              </div>
            </section>

            <section className="mb-12">
              <h2 className="text-2xl font-semibold mb-4">2. Information We Collect</h2>
              <p className="leading-relaxed mb-4">
                As a search engine, we process queries to provide results. This includes:
              </p>
              <ul className="list-disc pl-5 space-y-2">
                <li>Search terms (anonymized after processing)</li>
                <li>Device information (browser type, operating system)</li>
                <li>Approximate location (to provide localized search results)</li>
              </ul>
            </section>

            {/* Add more sections as needed */}
          </article>
        </div>
      </main>
    </div>
  );
};

export default LegalPage;