"use client"
//app/search/page.tsx
import { useState, useEffect, Suspense, useRef, useCallback, useMemo, } from "react"
import { useSearchParams, useRouter } from "next/navigation"
import { Filter, Calendar, Shield, ImageIcon, VideoIcon, GlobeIcon, ChevronDownIcon, Newspaper, ShoppingCart, MoreVertical, Play } from "lucide-react"
import { Button } from "@/components/ui/button"
import { Card, CardContent } from "@/components/ui/card"
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select"
import { LogoWithText, LogoTM } from "@/components/logo"
import { SearchWithAutocomplete } from "@/components/search-with-autocomplete"
import { ImageModal } from "@/components/image-modal"
import { VideoModal } from "@/components/video-modal"
import { SettingsModal } from "@/components/settings-modal"
import { AdCard } from "@/components/ad-card"
import { useSettings } from "@/components/settings-provider"
import { Globe, Video, ChevronDown, Search, Settings } from 'lucide-react';
import AiSearchResult from './AiSearchResult'
import GoogleWebSearchResults from '@/components/ui/GoogleWebSearchResults'
import GoogleImageSearchResults from '@/components/ui/GoogleImageSearchResults'
import Footer from '@/components/ui/Footer'
import { usePreservedResults } from '@/hooks/usePreservedResults'
import WebResults from '@/components/IndzsSearch/WebResults'
import ImageResults from '@/components/IndzsSearch/ImageResults'
import NewsResults from '@/components/IndzsSearch/NewsResults'
import ShoppingResults from '@/components/IndzsSearch/ShoppingResults'
import ActionBar from '@/components/ui/ActionBar'
import { useHistory } from '@/hooks/useHistory'
const { saveBrowserHistory } = useHistory();


const decodeHTMLEntities = (text) => {
    if (!text) return "";
    const textArea = document.createElement("textarea");
    textArea.innerHTML = text;
    return textArea.value;
};



export default function VideoResults({ searchType, videoResults, query, totalResults, handleVideoClick, hasMoreResults,

    handleLoadMore, loading, selectedVideo, isVideoModalOpen, handleCloseVideoModal
}) {

    return <>
        {searchType === "videos" && videoResults.length === 0 && query && (
            <div className="text-center py-12">
                <p className="text-muted-foreground">No video results found for "{query}"</p>
                <p className="text-sm text-muted-foreground mt-2">
                    Make sure your YouTube API key is configured in environment variables
                </p>
            </div>
        )}

        {/* === Video Results === */}
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-1 pt-5">
            {searchType === "videos" && videoResults.length > 0 && (
                <div className="max-w-3xl animate-in fade-in slide-in-from-bottom-2 duration-500">
                    {/* Result Count */}
                    <div className="text-sm text-muted-foreground mb-8 pl-1">
                        About {totalResults.toLocaleString()} results
      </div>

                    <div className="space-y-10 mt-[-10px]">
                        {videoResults.map((video) => (
                            <div
                                key={video.id}
                                className="group cursor-pointer"
                                onClick={() => handleVideoClick(video)}
                            >
                                {/* Source Info */}
                                <div className="flex items-center gap-2 mb-1 text-[13px] text-muted-foreground">
                                    <span className="hover:underline">www.youtube.com</span>
                                    <span>› watch</span>
                                    <button className="p-1 hover:bg-secondary rounded-full transition-colors">
                                        <MoreVertical className="w-3 h-3" />
                                    </button>
                                </div>

                                {/* Title - The main interactive element */}
                                <h3 className="text-xl text-[#2d6bcf] group-hover:underline mb-3 leading-tight font-normal">
                                    {decodeHTMLEntities(video.title)}
                                </h3>

                                {/* Content Row */}
                                <div className="flex flex-col sm:flex-row gap-4">
                                    {/* Thumbnail with Duration Badge */}
                                    <div className="relative shrink-0 w-full sm:w-[180px] aspect-video rounded-xl overflow-hidden bg-secondary">
                                        <img
                                            src={video.thumbnail || "/placeholder.svg"}
                                            alt={video.title}
                                            className="w-full h-full object-cover"
                                        />
                                        <div className="absolute inset-0 bg-black/10 group-hover:bg-black/0 transition-colors" />
                                        <div className="absolute bottom-1.5 right-1.5 bg-black/80 text-[11px] font-medium text-white px-1.5 py-0.5 rounded">
                                            {/* Assuming video.duration exists, otherwise placeholder */}
                                            {video.duration || "12:45"}
                                        </div>
                                        <div className="absolute inset-0 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity">
                                            <div className="w-10 h-10 bg-black/40 backdrop-blur-md rounded-full flex items-center justify-center border border-white/20">
                                                <Play className="w-5 h-5 text-white fill-current" />
                                            </div>
                                        </div>
                                    </div>

                                    {/* Snippet & Metadata */}
                                    <div className="flex-1 min-w-0 pt-0.5">
                                        <p className="text-[14px] text-muted-foreground line-clamp-2 leading-relaxed mb-2">
                                            {video.description || "No description available for this video result."}
                                        </p>
                                        <div className="flex items-center gap-2 text-[13px] text-muted-foreground">
                                            <span className="font-medium text-foreground/80">YouTube</span>
                                            <span>•</span>
                                            <span>{video.channelTitle}</span>
                                            <span>•</span>
                                            <span>{video.date ? new Date(video.date).toLocaleDateString('en-GB', { day: 'numeric', month: 'short', year: 'numeric' }) : ""}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        ))}
                    </div>

                    {/* Load More Section */}
                    {(hasMoreResults) && (
                        // <div className="mt-16 pt-8 border-t border-border flex justify-start">
                        <div className="flex justify-center mt-8 lg:w-fit" style={{
                            justifyContent: 'center',
                            background: 'var(--secondary)',
                            borderRadius: '50px',
                            color: 'white',
                            padding: '5px 20px'
                        }}>
                            <Button
                                onClick={handleLoadMore}
                                disabled={loading}
                            // variant="ghost"
                            // className="rounded-full px-8 hover:bg-secondary text-primary font-medium border border-border"
                            >
                                {loading ? "Loading..." : "Load More"}
                            </Button>
                        </div>
                    )}
                </div>
            )}
        </div>
        {/* === Video Results === */}
        {/* {searchType === "videos" && videoResults.length === 0 && query && (
            <div className="text-center py-12">
                <p className="text-muted-foreground">No video results found for "{query}"</p>
                <p className="text-sm text-muted-foreground mt-2">
                    Make sure your YouTube API key is configured in environment variables
                </p>
            </div>
        )}

        {searchType === "videos" && videoResults.length > 0 && (
            <>
                <div className="text-sm text-muted-foreground mb-6">About {totalResults.toLocaleString()} results</div>

                <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    {videoResults.map((video) => (
                        <Card
                            key={video.id}
                            className="group overflow-hidden hover:shadow-xl transition-all duration-300 border-0 bg-card/50 backdrop-blur-sm cursor-pointer"
                            onClick={() => handleVideoClick(video)}
                        >
                            <div className="aspect-video relative overflow-hidden">
                                <img
                                    src={video.thumbnail || "/placeholder.svg"}
                                    alt={video.title}
                                    className="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300"
                                />
                                <div className="absolute inset-0 flex items-center justify-center bg-black/40 opacity-0 group-hover:opacity-100 transition-all duration-300">
                                    <div className="w-16 h-16 bg-red-600 rounded-full flex items-center justify-center shadow-lg transform scale-75 group-hover:scale-100 transition-transform duration-300">
                                        <svg className="w-8 h-8 text-white ml-1" fill="currentColor" viewBox="0 0 24 24">
                                            <path d="M8 5v14l11-7z" />
                                        </svg>
                                    </div>
                                </div>
                                <div className="absolute bottom-2 right-2 bg-black/80 text-white text-xs px-2 py-1 rounded">
                                    Video
                        </div>
                            </div>
                            <CardContent className="p-5">
                                <h3 className="font-semibold mb-3 line-clamp-2 text-primary leading-snug">{video.title}</h3>
                                <div className="space-y-2">
                                    {video.channelTitle && (
                                        <p className="font-medium text-accent text-sm">{video.channelTitle}</p>
                                    )}
                                    <div className="flex items-center justify-between">
                                        <div className="flex items-center gap-1 text-xs text-muted-foreground">
                                            <Calendar className="w-3 h-3" />
                                            <span>{video.date ? new Date(video.date).toLocaleDateString() : ""}</span>
                                        </div>
                                        <span className="inline-flex items-center gap-1 text-accent hover:text-accent/80 font-medium text-sm transition-colors group-hover:underline decoration-2 underline-offset-2">
                                            <VideoIcon className="w-3 h-3" />
                              Watch
                            </span>
                                    </div>
                                </div>
                                {video.description && (
                                    <p className="text-sm text-foreground/70 mt-3 line-clamp-2 leading-relaxed">
                                        {video.description}
                                    </p>
                                )}
                            </CardContent>
                        </Card>
                    ))}
                </div>

                {(hasMoreResults || true) && (
                    <div className="flex justify-center mt-8 lg:w-fit" style={{
                        justifyContent: 'center',
                        background: 'var(--secondary)',
                        borderRadius: '50px',
                        color: 'white',
                        padding: '5px 20px'
                    }}>
                        <Button onClick={handleLoadMore} disabled={loading}>
                            {loading ? "Loading..." : "Load More"}
                        </Button>
                    </div>
                )}

                <VideoModal video={selectedVideo} isOpen={isVideoModalOpen} onClose={handleCloseVideoModal} />
            </>
        )} */}
    </>
}