import React from 'react';
import { Newspaper, Radio } from 'lucide-react';

const NewsResults = () => {
  return (
    <div className="relative overflow-hidden rounded-3xl border border-[var(--border)] bg-[var(--card)] p-1 text-[var(--card-foreground)] transition-all duration-500 hover:border-[var(--primary)]/30 group">
      {/* Background Shimmer */}
      <div className="absolute inset-0 shimmer-bg pointer-events-none" />
      
      <div className="relative flex flex-col items-center justify-center p-8 border border-dashed border-[var(--border)] rounded-[calc(1.5rem-4px)]">
        <div className="animate-float [animation-delay:0.5s] mb-6">
          <div className="relative flex items-center justify-center w-20 h-20 rounded-2xl bg-[var(--secondary)] text-[var(--primary)] ring-1 ring-[var(--border)]">
            <Newspaper size={32} strokeWidth={1.5} className="text-[var(--foreground)]"/>
            <div className="absolute -top-2 -right-2 bg-[var(--chart-3)] p-1.5 rounded-lg shadow-lg">
              <Radio size={14} className="text-[var(--background)]" />
            </div>
          </div>
        </div>

        <div className="space-y-3 text-center">
          <h3 className="text-xl font-medium tracking-tight">News Feed</h3>
          <p className="text-sm text-[var(--muted-foreground)] max-w-[200px] leading-relaxed">
            Connecting real-time global news sources.<br/>Coming Soon
          </p>
        </div>

        <div className="mt-8 flex items-center gap-2 px-4 py-1.5 rounded-full bg-[var(--muted)]/50 border border-[var(--border)]">
          <span className="relative flex h-2 w-2">
            <span className="animate-ping absolute inline-flex h-full w-full rounded-full bg-[var(--chart-1)] opacity-75"></span>
            <span className="relative inline-flex rounded-full h-2 w-2 bg-[var(--chart-1)]"></span>
          </span>
          <span className="text-[10px] font-bold uppercase tracking-widest text-[var(--muted-foreground)]">Syncing</span>
        </div>
      </div>
    </div>
  );
};

export default NewsResults