import React, { useState, useEffect } from 'react';
import { MoreVertical, ChevronRight, PlayCircle } from 'lucide-react';

interface ApiResponse {
  title: string;
  summary: string;
  description?: string;
  pageUrl?: string;
  images?: string[];
}
function titleKeywordsExistInParagraph(title: string, paragraph: string) {
  // Convert both to lowercase for case-insensitive match
  const lowerTitle = title.toLowerCase();
  const lowerParagraph = paragraph.toLowerCase();

  // Spl
  // it title into words, remove common stopwords if needed
  const titleWords = lowerTitle.split(/\s+/).filter(Boolean);

  // Check if all words exist in paragraph
  return titleWords.every((word) => lowerParagraph.includes(word));
}



const KnowledgePanel = ({ query, search }) => {
  const [summary, setSummary] = useState<string | null>(null);
  const [sources, setSources] = useState<Object | null>(null)
  const [error, setError] = useState<string | null>(null);
  const [copied, setCopied] = useState(false);
  const [summaryData, setSummaryData] = useState<ApiResponse | null>(null)
  const [isShowPanel, setIsShowPanel] = useState(true)
  const fetchSummary = async () => {
    // if(!query) return
    setError(null);
    setSummary(null);

    try {
      console.log("fetching")
      const res = await fetch("/api/wikipedia-summary", {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
        },
        body: JSON.stringify({ query }),
      });

      const data = await res.json();

      if (!res.ok) {
        setError(data.error || "Something went wrong");
      } else {
        setSummaryData(data)
        setSummary(data.summary);
        setSources([{
          title: "Wikipedia",
          url: data.pageUrl
        }])
        setIsShowPanel(titleKeywordsExistInParagraph(query, data.summary))
        // setSummary(null)
      }
    } catch (err) {
      setError("Failed to fetch summary");
    }
  };
  useEffect(() => {
    fetchSummary()
  }, [search])

  if (!summary) {
    return <></>
  }


  return (


    <>

      {summary && isShowPanel && <div className="max-w-[400px] mx-auto bg-background text-foreground border border-border rounded-xl overflow-hidden font-sans shadow-xl
      animate-in fade-in slide-in-from-bottom-4 duration-700
      "
        style={{
          height: 'fit-content',
          boxShadow: 'none',
          // borderRadius:0,
          // borderTop:'none',
          // borderRight :'none',
          // borderBottom :'none'
        }}
      >
        {/* Header */}
        <div className="p-4 flex justify-between items-center">
          <div className="flex items-center gap-2">
            <div className="text-secondary font-bold text-xl">{summaryData?.title || query
              ? query.charAt(0).toUpperCase() + query.slice(1)
              : ""}</div>
          </div>
          {/* <MoreVertical className="w-5 h-5 text-muted-foreground cursor-pointer" /> */}
        </div>

        {/* Image Grid */}

        {summaryData?.images && <div className="grid grid-cols-2 gap-1 px-4 h-48" style={{ height: 'fit-content' }}>
          {summaryData?.images[0] && <div className="h-full rounded-l-2xl overflow-hidden bg-muted"
            style={{ maxHeight: '210px' }}
          >
            <img src={summaryData?.images[0]} alt="Meta diversity" className="w-full h-full object-cover" />
          </div>}
          <div className="grid grid-rows-2 gap-1 h-full">
            {summaryData?.images[1] && <div className="rounded-tr-2xl overflow-hidden bg-muted"
              style={{ maxHeight: '100px' }}
            >
              <img src={summaryData?.images[1]} alt="Meta office" className="w-full h-full object-cover" />
            </div>}
            {summaryData?.images[2] && <div className="rounded-br-2xl overflow-hidden bg-muted relative"
              style={{ maxHeight: '100px' }}
            >
              <img src={summaryData?.images[2]} alt="Meta Executive" className="w-full h-full object-cover" />
            </div>}
          </div>
        </div>}

        {/* Description */}
        <div className="p-4">
          <p className="text-sm leading-relaxed">
            {summary}
          </p>
          <a href={sources[0].url} target="_blank"><span className="text-blue-400 cursor-pointer">Wikipedia</span></a>
        </div>

        {/* <hr className="border-border mx-4" /> */}

        {/* Key Info */}
        {/* <div className="p-4 space-y-2 text-sm">
        <p><span className="font-bold">Founders:</span> <span className="text-blue-400">Mark Zuckerberg, Eduardo Saverin, Dustin Moskovitz...</span></p>
        <p><span className="font-bold">CEO:</span> <span className="text-blue-400">Mark Zuckerberg</span> (Jul 2004–)</p>
        <p><span className="font-bold">CFO:</span> <span className="text-blue-400">Susan Li</span></p>
        <p><span className="font-bold">Founded:</span> 4 February 2004, Cambridge, MA</p>
      </div> */}

        {/* <hr className="border-border mx-4" /> */}

        {/* Profiles */}
        {/* <div className="p-4">
        <h3 className="text-md font-medium mb-4">Profiles</h3>
        <div className="flex justify-between px-2">
          {['Instagram', 'Facebook', 'YouTube', 'LinkedIn'].map((app) => (
            <div key={app} className="flex flex-col items-center gap-2 cursor-pointer group">
              <div className="w-12 h-12 rounded-full border border-border flex items-center justify-center group-hover:bg-accent transition-colors">
                <div className="w-8 h-8 bg-muted rounded-full" />
              </div>
              <span className="text-xs text-muted-foreground">{app}</span>
            </div>
          ))}
        </div>
      </div> */}

        {/* <hr className="border-border mx-4" /> */}

        {/* Videos Section */}
        {/* <div className="p-4">
        <h3 className="text-md font-medium mb-3">Videos from Meta</h3>
        <div className="flex gap-3 overflow-x-auto pb-2 scrollbar-hide">
          <div className="min-w-[200px] border border-border rounded-xl overflow-hidden bg-muted/30">
            <div className="relative h-24 bg-muted">
              <div className="absolute bottom-2 left-2 bg-black/60 text-[10px] px-1 rounded flex items-center">
                <PlayCircle className="w-3 h-3 mr-1" /> 0:57
              </div>
            </div>
            <div className="p-2">
              <p className="text-xs font-medium line-clamp-2">With Meta Omnilingual Automatic Speech Recognition...</p>
              <p className="text-[10px] text-muted-foreground mt-1 italic">Facebook · 1mo</p>
            </div>
          </div>
          <div className="min-w-[200px] border border-border rounded-xl overflow-hidden bg-muted/30">
             <div className="relative h-24 bg-muted">
                <div className="absolute bottom-2 left-2 bg-black/60 text-[10px] px-1 rounded flex items-center">
                  <PlayCircle className="w-3 h-3 mr-1" /> 0:32
                </div>
             </div>
             <div className="p-2">
              <p className="text-xs font-medium line-clamp-2">It's not magic - it's AI</p>
              <p className="text-[10px] text-muted-foreground mt-1 italic">Facebook · 2mo</p>
            </div>
          </div>
        </div>
      </div> */}

        {/* Ratings */}
        {/* <div className="flex border-t border-border">
        <div className="flex-1 p-4 text-center border-r border-border">
          <div className="text-lg font-bold">100%</div>
          <div className="text-[10px] text-muted-foreground">AdVoid</div>
        </div>
        <div className="flex-1 p-4 text-center">
          <div className="text-lg font-bold">100%</div>
          <div className="text-[10px] text-muted-foreground">ScamAdvisor Trust score</div>
        </div>
      </div> */}

        {/* Related Searches */}
        <div className="p-4 bg-muted/10 border-t border-border">
          {/*<h3 className="text-sm font-medium mb-4">People also search for</h3>
        <div className="grid grid-cols-4 gap-2">
           {['Instagram', 'WhatsApp', 'Facebook', 'TikTok'].map((item) => (
             <div key={item} className="flex flex-col items-center gap-2">
                <div className="w-12 h-12 rounded-xl bg-muted border border-border" />
                <span className="text-[10px] text-muted-foreground">{item}</span>
             </div>
           ))}
        </div>*/}
          <a href={sources[0].url} target="_blank">
            <button className="w-full mt-6 py-2 bg-muted rounded-full text-sm font-medium flex items-center justify-center gap-1 hover:bg-accent transition-colors">
              Read More <ChevronRight className="w-4 h-4" />
            </button>
          </a>
        </div>
      </div>}
    </>
  );
};

export default KnowledgePanel;