"use client"
//app/search/page.tsx
import React, { useState, useEffect, Suspense, useRef, useCallback, useMemo } from "react"
import { useSearchParams, useRouter } from "next/navigation"
// import { Filter, Calendar, Shield, ImageIcon, VideoIcon, GlobeIcon, ChevronDownIcon } from "lucide-react"
import { Button } from "@/components/ui/button"
// import { Card, CardContent } from "@/components/ui/card"
// import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select"
// import { LogoWithText } from "@/components/logo"
// import { SearchWithAutocomplete } from "@/components/search-with-autocomplete"
import { ImageModal } from "@/components/image-modal"
// import { VideoModal } from "@/components/video-modal"
// import { SettingsModal } from "@/components/settings-modal"
// import { AdCard } from "@/components/ad-card"
// import { useSettings } from "@/components/settings-provider"
// import { Globe, Video, ChevronDown, Search, Settings } from 'lucide-react';
// import AiSearchResult from './AiSearchResult'
// import GoogleWebSearchResults from '@/components/ui/GoogleWebSearchResults'
import GoogleImageSearchResults from '@/components/ui/GoogleImageSearchResults'
// import Footer from '@/components/ui/Footer'
// import { usePreservedResults } from '@/hooks/usePreservedResults'
// import { useHistory } from '@/hooks/useHistory'
// import WebResults from '@/components/IndzsSearch/WebResults'
// import ImageResults from '@/components/IndzsSearch/ImageResults'


const ImageResults = ({ searchType, imageResults, query, totalResults, handleImageClick, hasMoreResults, loading, handleLoadMore,
    selectedImage,
    isModalOpen,
    handleCloseModal,

}) => {
    const router = useRouter()

    if(!query){
    return <>
    
      {/* === Image Results === */}
        {searchType === "images" && (
            <div className="text-center py-12">
                <p className="text-muted-foreground">No image results found for "{query}"</p>
                <img src="/no_result.png" alt="no_results" width={250} className="mx-auto" />
            </div>
        )}

    </>
    }
    return <>

      

        {searchType === "images" && imageResults.length === 0 && (
            // <div className="text-center py-12">

            <div className="space-y-1 search-results-container">
                {/* <GoogleImageSearchResults query={query} /> */}
                {/* <p className="text-muted-foreground">No web results found for "{query}"</p> */}
                {/* <img src="/no_result.png" alt="no_results" width={250} className="mx-auto" /> */}
            </div>
        )}

        {searchType === "images" && imageResults.length > 0 && (
            <>
                <div className="text-sm text-muted-foreground mb-6">About {totalResults.toLocaleString()} results</div>

                <div className="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6 gap-4">
                    {imageResults.map((image) => (
                        <div key={image.id} className="group cursor-pointer" onClick={() => handleImageClick(image)}>
                            <div className="aspect-square bg-muted rounded-lg overflow-hidden mb-2 hover:shadow-md transition-shadow">
                                <img
                                    src={image.imgurl || "/placeholder.svg"}
                                    alt={image.title}
                                    className="w-full h-full object-cover group-hover:scale-105 transition-transform duration-200"
                                    onError={(e) => {
                                        console.log("[v0] Image failed to load:", image.imgurl, "for", image.title)
                                        if (image.url && !e.currentTarget.src.includes("google.com/s2/favicons")) {
                                            try {
                                                const domain = new URL(image.url).hostname
                                                e.currentTarget.src = `https://www.google.com/s2/favicons?domain=${domain}&sz=128`
                                            } catch {
                                                e.currentTarget.src =
                                                    "/placeholder.svg?height=200&width=200&text=" +
                                                    encodeURIComponent(image.title.substring(0, 20))
                                            }
                                        } else {
                                            e.currentTarget.src =
                                                "/placeholder.svg?height=200&width=200&text=" +
                                                encodeURIComponent(image.title.substring(0, 20))
                                        }
                                    }}
                                    onLoad={() => {
                                        console.log("[v0] Image loaded successfully:", image.imgurl, "for", image.title)
                                    }}
                                />
                            </div>

                            <h3 className="text-sm font-medium line-clamp-2 mb-1 group-hover:text-blue-600 transition-colors">
                                {image.title}
                            </h3>

                            <div className="flex items-center gap-1 mb-2">
                                {image.favicon && (
                                    <img
                                        src={
                                            image.favicon ||
                                            `https://www.google.com/s2/favicons?domain=${new URL(image.url).hostname || "/placeholder.svg"}&sz=16`
                                        }
                                        alt=""
                                        className="w-3 h-3 flex-shrink-0"
                                        onError={(e) => {
                                            e.currentTarget.src = "/placeholder.svg?height=12&width=12"
                                        }}
                                    />
                                )}
                                <span className="text-xs text-muted-foreground truncate">{new URL(image.url).hostname}</span>
                            </div>

                            {image.keywords && image.keywords.length > 0 && (
                                <div className="flex flex-wrap gap-1">
                                    {image.keywords.slice(0, 3).map((keyword) => (
                                        <span
                                            key={keyword}
                                            className="text-xs text-blue-600 hover:underline cursor-pointer"
                                            onClick={(e) => {
                                                e.stopPropagation()
                                                router.push(`/search?q=${encodeURIComponent(keyword)}&type=images`)
                                            }}
                                        >
                                            {keyword}
                                        </span>
                                    ))}
                                </div>
                            )}
                        </div>
                    ))}
                </div>

                {!hasMoreResults && <GoogleImageSearchResults query={query} />}
                {(hasMoreResults) && (
                    <div className="flex justify-center mt-8 lg:w-fit" style={{
                            justifyContent: 'center',
                            background: 'var(--secondary)',
                            borderRadius: '50px',
                            color: 'white',
                            padding: '5px 20px'
                        }}>
                        <Button onClick={handleLoadMore} disabled={loading}>
                            {loading ? "Loading..." : "Load More"}
                        </Button>
                    </div>
                )} 

                <ImageModal image={selectedImage} isOpen={isModalOpen} onClose={handleCloseModal} />
            </>
        )}

    </>
}



export default React.memo(ImageResults, (prev, next) => {
  return prev.value === next.value;
})