"use client"
import React, { useState } from "react";
// import { User, ShieldCheck, RefreshCw, ExternalLink, ArrowRight, LogIn, TrendingUp } from "lucide-react";
import { LoginModal } from "@/components/ui/LoginModal";
// import { FullscreenPopup } from "@/components/ui/FullscreenPopup"
import { Portal } from "@/components/ui/Portal"
// import { useAuth } from "@/components/auth-provider"
// import { useRouter } from "next/navigation"
import { LucideIcon, LogIn } from "lucide-react";

interface AuthGuardProps {
  title: string;
  description: string;
  icon: LucideIcon;
  actionText?: string;
  onAction?: () => void;
}


export default function AuthGuard({title, description, icon:Icon}: AuthGuardProps) {
    const [isLoggedIn, setIsLoggedIn] = useState(true);
    const [isModalOpen, setIsModalOpen] = useState(false);
    // const { user, logout } = useAuth()
    // const router = useRouter()


    return <div
    className="rounded-3xl border overflow-hidden transition-all duration-500 shadow-xl"
                style={{ backgroundColor: 'var(--card)', borderColor: 'var(--border)', color: 'var(--card-foreground)' }}
                >
        {<div className="p-8 sm:p-16 text-center animate-in fade-in duration-500">
            <div className="w-16 h-16 sm:w-20 sm:h-20 rounded-3xl flex items-center justify-center mx-auto mb-6 shadow-inner"
                style={{ backgroundColor: 'var(--muted)' }}>
                <Icon size={32} className="sm:size-10" style={{ color: 'var(--muted-foreground)' }} />
            </div>
            <h2 className="text-2xl sm:text-3xl font-bold mb-3 tracking-tight">{title}</h2>
            <p className="max-w-[280px] sm:max-w-xs mx-auto mb-8 text-xs sm:text-sm leading-relaxed" style={{ color: 'var(--muted-foreground)' }}>
                {description}
            </p>
            <button
                onClick={() => setIsModalOpen(true)}
                className="w-full sm:w-auto px-8 py-4 rounded-2xl font-bold flex items-center justify-center gap-3 mx-auto transition-all hover:scale-105 active:scale-95 shadow-xl text-sm sm:text-base"
                style={{ backgroundColor: 'var(--primary)', color: 'var(--primary-foreground)' }}
            >
                <LogIn size={20} />
              Sign in to Indzs
            </button>
        </div>}
        <Portal>
            {isModalOpen && <div className="fixed inset-0 z-[9999] bg-black/80 backdrop-blur-lg">
                <LoginModal
                    isOpen={isModalOpen}
                    onClose={() => setIsModalOpen(false)}
                    onLogin={() => { setIsLoggedIn(true); setIsModalOpen(false); }}
                />
            </div>}
        </Portal>

    </div>
}