"use client"

import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Video } from "lucide-react"

export default function VideoManagementPage() {
  return (
    <div className="space-y-6">
      <div>
        <h1 className="text-3xl font-bold font-playfair text-foreground">Video Results</h1>
        <p className="text-muted-foreground mt-2">Video results management is currently disabled</p>
      </div>

      <Card>
        <CardHeader className="text-center">
          <div className="w-16 h-16 bg-muted rounded-full flex items-center justify-center mx-auto mb-4">
            <Video className="w-8 h-8 text-muted-foreground" />
          </div>
          <CardTitle>Video Results Management</CardTitle>
          <CardDescription>
            This section is currently unavailable. Video results are managed automatically by the search engine.
          </CardDescription>
        </CardHeader>
        <CardContent className="text-center">
          <p className="text-sm text-muted-foreground">
            Contact your administrator if you need access to video results management features.
          </p>
        </CardContent>
      </Card>
    </div>
  )
}
