import type React from "react"
import { Inter, Playfair_Display } from "next/font/google"
import { AdminAuthProvider } from "@/components/admin/admin-auth-provider"
import { AdminAuthGuard } from "@/components/admin/admin-auth-guard"
import { ErrorBoundary } from "@/components/error-boundary"

const inter = Inter({
  subsets: ["latin"],
  variable: "--font-inter",
  display: "swap",
})

const playfair = Playfair_Display({
  subsets: ["latin"],
  variable: "--font-playfair",
  display: "swap",
})

export default function AdminLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <ErrorBoundary>
      <AdminAuthProvider>
        <div className={`${inter.variable} ${playfair.variable} min-h-screen bg-background`}>
          <AdminAuthGuard>{children}</AdminAuthGuard>
        </div>
      </AdminAuthProvider>
    </ErrorBoundary>
  )
}
