import { Suspense } from "react"
import { DashboardStats } from "@/components/admin/dashboard-stats"
import { RecentActivity } from "@/components/admin/recent-activity"
import { CollectionOverview } from "@/components/admin/collection-overview"

export default function AdminDashboard() {
  return (
    <div className="space-y-6">
      <div>
        <h1 className="text-3xl font-bold font-playfair text-foreground">Dashboard</h1>
        <p className="text-muted-foreground mt-2">Overview of your IndusSearch collections and activity</p>
      </div>

      <Suspense fallback={<div className="animate-pulse bg-card h-32 rounded-lg" />}>
        <DashboardStats />
      </Suspense>

      <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <Suspense fallback={<div className="animate-pulse bg-card h-64 rounded-lg" />}>
          <CollectionOverview />
        </Suspense>

        <Suspense fallback={<div className="animate-pulse bg-card h-64 rounded-lg" />}>
          <RecentActivity />
        </Suspense>
      </div>
    </div>
  )
}
