import {
  User,
  Palette,
  Search,
  Globe,
  Settings,
  RotateCcw,
  TrendingUp,
  SearchCheck,
} from "lucide-react";

export type SettingsTabId =
  | "You and Indzs"
  | "Appearance"
  | "Search Preferences"
  | "Language & Region"
  | "Current Settings"
  | "Search History"
  | "Ads Center"
  | "Submit Website";

export interface SettingsConfigItem {
  id: SettingsTabId;
  title: string;
  description: string;
  icon: any;
  keywords: string[];
}


export const SETTINGS_CONFIG: SettingsConfigItem[] = [
  {
    id: "You and Indzs",
    title: "Account",
    description: "Manage your personal information and account details",
    icon: User,
    keywords: [
      "account",
      "profile",
      "user",
      "personal",
      "login",
      "signup",
      "email",
      "password",
      "security",
      "you",
      "indzs",
    ],
  },

  {
    id: "Appearance",
    title: "Appearance",
    description: "Customize theme, colors, and visual preferences",
    icon: Palette,
    keywords: [
      "theme",
      "dark mode",
      "light mode",
      "appearance",
      "colors",
      "ui",
      "display",
      "layout",
      "font",
    ],
  },

  {
    id: "Search Preferences",
    title: "Search Preferences",
    description: "Control how search works and what you see",
    icon: Search,
    keywords: [
      "search",
      "preferences",
      "results",
      "filters",
      "ranking",
      "safe search",
      "query",
      "engine",
    ],
  },

  {
    id: "Language & Region",
    title: "Language & Region",
    description: "Set language, region, and localization options",
    icon: Globe,
    keywords: [
      "language",
      "region",
      "country",
      "locale",
      "timezone",
      "translation",
      "international",
    ],
  },

  {
    id: "Current Settings",
    title: "System Settings",
    description: "View and manage your current configuration",
    icon: Settings,
    keywords: [
      "settings",
      "system",
      "configuration",
      "preferences",
      "options",
      "general",
    ],
  },

  {
    id: "Search History",
    title: "Search History",
    description: "Review and manage your past searches",
    icon: RotateCcw,
    keywords: [
      "history",
      "search history",
      "recent",
      "activity",
      "clear history",
      "delete searches",
    ],
  },

  {
    id: "Ads Center",
    title: "Ads Center",
    description: "Manage ads, campaigns, and performance insights",
    icon: TrendingUp,
    keywords: [
      "ads",
      "advertising",
      "campaigns",
      "marketing",
      "promotion",
      "analytics",
      "performance",
      "monetization",
    ],
  },

  {
    id: "Submit Website",
    title: "Index Your Website",
    description: "Submit your website for search indexing",
    icon: SearchCheck,
    keywords: [
      "submit website",
      "index",
      "search console",
      "seo",
      "crawl",
      "website submission",
      "search engine",
      "visibility",
    ],
  },
];
