"use client"
import Link from 'next/link';
import React, { useState, useEffect, useRef } from "react";
// Added ChevronLeft and ChevronRight for the toggle button
import { Menu, X, User, Palette, Search, Globe, Settings, ChevronLeft, ChevronRight, Home, RotateCcw, TrendingUp, SearchCheck } from "lucide-react";
import '@/styles/settings.css'
import AppearanceSettings from "./AppearanceSettings"
import SearchPreferences from "./SearchPreferences"
import LanguageRegion from "./LanguageRegion"
import CurrentSettings from "./CurrentSettings"
import YouAndGoogle from "./YouAndGoogle"
import SearchHistory from './SearchHistory'
import AdsCenter from './AdsCenter'
import SubmitWebsite from './SubmitWebsite'
import { useRouter, useSearchParams } from "next/navigation";
import { useSettings } from '@/context/SettingsContext'
import SettingsSearch from './SettingsSearch'
const MENU_ITEMS = [
  { id: "You and Indzs", icon: User },
  { id: "Appearance", icon: Palette },
  { id: "Search Preferences", icon: Search },
  { id: "Language & Region", icon: Globe },
  { id: "Current Settings", icon: Settings },
  { id: "Search History", icon: RotateCcw },
  { id: "Ads Center", icon: TrendingUp },
  { id: "Submit Website", icon: SearchCheck },
];



const isValidTab = (tab: string | null) =>
  MENU_ITEMS.some((item) => item.id === tab);

export default function SettingsPage() {
  const [active, setActive] = useState("You and Indzs");
  const [isMenuOpen, setIsMenuOpen] = useState(false);
  const [isCollapsed, setIsCollapsed] = useState(false); // New State
  const [indicatorStyle, setIndicatorStyle] = useState({ top: 0, height: 0 });
  const searchParams = useSearchParams();
  const router = useRouter()
  const { tab, setTab } = useSettings();
  console.log("Settings page" + tab)

  const tabQuery = searchParams.get("tab");
  useEffect(() => {
    // console.log(tabQuery)
    if (tabQuery) {
      const activeTab = isValidTab(tabQuery) ? tabQuery : "You and Indzs";
      setTab(activeTab)
      //   // setActive(activeTab)
      router.replace("/settings");
    }
  }, [tabQuery])


  const itemRefs = useRef<{ [key: string]: HTMLButtonElement | null }>({});

  useEffect(() => {
    const activeElement = itemRefs.current[active];
    if (activeElement) {
      setIndicatorStyle({
        top: activeElement.offsetTop + 6,
        height: activeElement.offsetHeight - 12,
      });
    }
  }, [active, isCollapsed]); // Re-run if collapsed state changes

  useEffect(() => {
    if (tab) {
      const activeTab = isValidTab(tab) ? tab : "You and Indzs";
      setActive(activeTab)
    }
  }, [tab])

  return (
    <div className="flex h-screen overflow-hidden font-sans"
      style={{ backgroundColor: 'var(--background)', color: 'var(--foreground)' }}>

      {/* Mobile Overlay */}
      {isMenuOpen && (
        <div
          className="fixed inset-0 z-40 md:hidden backdrop-blur-sm bg-black/40"
          onClick={() => setIsMenuOpen(false)}
        />
      )}

      {/* Sidebar */}
      <aside className={`
        fixed inset-y-0 left-0 z-50 transform transition-all duration-300 ease-in-out md:relative md:translate-x-0
        ${isMenuOpen ? "translate-x-0" : "-translate-x-full"}
        ${isCollapsed ? "w-20" : "w-72"} 
      `} style={{ backgroundColor: 'var(--sidebar)', borderRight: '1px solid var(--sidebar-border)' }}>

        <div className="flex flex-col h-full p-4">
          <div className={`flex items-center mb-8 px-2 ${isCollapsed ? "justify-center" : "justify-between"}`}>
            {!isCollapsed && (
              <h2 className="text-xl font-semibold overflow-hidden whitespace-nowrap" style={{ color: 'var(--sidebar-foreground)' }}>
                Settings
              </h2>
            )}
            {/* Collapse Toggle Button (Desktop) */}
            <button
              onClick={() => setIsCollapsed(!isCollapsed)}
              className="hidden md:flex p-2 rounded-lg hover:bg-white/10 transition-colors"
              style={{ color: 'var(--muted-foreground)' }}
            >
              {isCollapsed ? <ChevronRight size={20} /> : <ChevronLeft size={20} />}
            </button>
          </div>

          <nav className="sidebar-container space-y-1 relative flex-1">
            {/* The Animated Line (Hidden or adjusted if collapsed) */}
            {!isCollapsed && (
              <div
                className="active-indicator"
                style={{
                  transform: `translateY(${indicatorStyle.top}px)`,
                  height: `${indicatorStyle.height}px`
                }}
              />
            )}

            {MENU_ITEMS.map((item) => (
              <button
                key={item.id}
                ref={(el) => (itemRefs.current[item.id] = el)}
                onClick={() => {
                  setActive(item.id);
                  setTab(item.id)
                  setIsMenuOpen(false);
                }}
                title={isCollapsed ? item.id : ""} // Show tooltip when collapsed
                className={`
                  sidebar-item w-full flex items-center gap-4 py-3 rounded-lg text-sm font-medium transition-all
                  ${active === item.id ? "active bg-white/5" : ""}
                  ${isCollapsed ? "justify-center px-0" : "px-4"}
                `}
              >
                <item.icon size={20} className="shrink-0" />
                {!isCollapsed && <span className="truncate">{item.id}</span>}
              </button>
            ))}
          </nav>

          <Link
            href="/"
            title={isCollapsed ? "Back to Home" : ""}
            className={`
                sidebar-item w-full flex items-center gap-4 py-3 rounded-lg text-sm font-medium transition-all
                hover:bg-white/5
                ${isCollapsed ? "justify-center px-0" : "px-4"}
              `}
          >
            <Home
              size={20}
              className="shrink-0 transition-transform group-hover:scale-110"
            />
            {!isCollapsed && (
              <span className="truncate">Back to Home</span>
            )}
          </Link>

          {/* Optional: Collapse Toggle at the bottom */}
          {/* <div className="pt-4 border-t border-white/5 md:hidden">
             <button onClick={() => setIsMenuOpen(false)} className="w-full flex justify-center p-2 text-muted-foreground">
                <X size={20} />
             </button>
          </div> */}
        </div>
      </aside>

      {/* Main Content */}
      <main className="flex-1 flex flex-col min-w-0">
        <header className="flex items-center p-4 md:hidden"
          style={{ borderBottom: '1px solid var(--border)', backgroundColor: 'var(--sidebar)' }}>
          <button onClick={() => setIsMenuOpen(true)} style={{ color: 'var(--muted-foreground)' }}>
            <Menu size={24} />
          </button>
          <span className="ml-4 font-medium" style={{ color: 'var(--foreground)' }}>{active}</span>
        </header>

        <div className="flex-1 overflow-y-auto p-6 md:p-12">
          <div className="max-w-3xl mx-auto">
            <SettingsSearch

            />
            {/* <input
              type="text"
              placeholder="Search settings"
              className="w-full mb-10 px-6 py-4 rounded-xl outline-none transition-all"
              style={{
                backgroundColor: 'var(--input)',
                color: 'var(--foreground)',
                border: '1px solid var(--border)'
              }}
            /> */}

            <div className="animate-in fade-in slide-in-from-bottom-2 duration-500">
              {/* <h3 className="text-2xl font-bold mb-4">{active}</h3> */}
              <div style={{ color: 'var(--muted-foreground)' }}>
                {/* Your Component Logic here */}
                {renderContent(active)}
              </div>
            </div>
          </div>
        </div>
      </main>
    </div>
  );
}


function renderContent(active: string) {
  switch (active) {
    case "You and Indzs":
      return <YouAndGoogle />

    case "Appearance":
      return <AppearanceSettings />

    case "Search Preferences":
      return <SearchPreferences />

    case "Language & Region":
      return <LanguageRegion />

    case "Current Settings":
      return (
        <CurrentSettings />
      )
    case "Search History":
      return <SearchHistory />
    case "Ads Center":
      return <AdsCenter />
    case "Submit Website":
      return <SubmitWebsite />
    default:
      return null
  }
}