const menuItems = [
  "You and Indzs",
  "Current Settings",
  "Search Preferences",
  "Appearance",
  "Language & Region",
]

export default function Sidebar({
  active,
  onChange,
}: {
  active: string
  onChange: (item: string) => void
}) {
  return (
    <aside className="w-72 bg-[#1f1f1f] border-r border-gray-700 p-4 overflow-y-auto">
      <h1 className="text-xl font-semibold mb-6">Settings</h1>

      <nav className="space-y-1">
        {menuItems.map((item) => (
          <div
            key={item}
            onClick={() => onChange(item)}
            className={`px-3 py-2 rounded-md cursor-pointer transition
              ${
                active === item
                  ? "bg-[#8ab4f8] text-black font-medium"
                  : "hover:bg-[#2a2a2a]"
              }
            `}
          >
            {item}
          </div>
        ))}
      </nav>
    </aside>
  )
}
