"use client"

import { useState, useEffect } from "react"
import { useTheme } from "@/components/theme-provider"
import { Palette } from "lucide-react";

export default function AppearanceSettings() {
  const [autoComplete, setAutoComplete] = useState(true)
  const { theme, setTheme } = useTheme()
  const themes = ["Dark", "Light", "System"];



  useEffect(() => {
    // 1. Get the existing object first to avoid overwriting other keys (like language/region)
    const savedSettings = localStorage.getItem("indus-search-settings");
    const currentSettings = savedSettings ? JSON.parse(savedSettings) : {};

    // 2. Merge the new state values into the object
    const updatedSettings = {
      ...currentSettings,
      theme: theme.toLowerCase(), // Ensuring it matches your "system" lowercase requirement
      autoComplete: autoComplete
    };

    // 3. Save back to localStorage
    localStorage.setItem("indus-search-settings", JSON.stringify(updatedSettings));
  }, [theme, autoComplete]); // This effect runs whenever these two change



  return (
    <div
      className="rounded-2xl overflow-hidden transition-all duration-500 animate-in fade-in slide-in-from-bottom-4"
      style={{
        backgroundColor: 'var(--card)',
        border: '1px solid var(--border)',
      }}
    >

      <div className="p-8 border-b" style={{ borderColor: 'var(--border)', color: 'var(--card-foreground)'}}>
          <h2 className="text-xl font-bold tracking-tight flex items-center gap-2">
            <Palette size={20} style={{ color: 'var(--chart-3)' }} />
            Appearance Settings
          </h2>
          <p className="text-sm mt-1" style={{ color: 'var(--muted-foreground)' }}>
            Customize the app’s look and visual preferences.
          </p>
        </div>

      <div className="p-6 space-y-8">
        {/* <h2 className="text-xs font-bold uppercase tracking-[0.2em]"
          style={{ color: 'var(--muted-foreground)' }}>
          Appearance Settings
        </h2> */}

        

        {/* Theme Selection */}
        <div className="space-y-3">
          <p className="text-sm font-medium" style={{ color: 'var(--foreground)' }}>Interface Theme</p>
          <div className="flex p-1 rounded-xl gap-1" style={{ backgroundColor: 'var(--input)' }}>
            {themes.map((t) => (
              <button
                key={t}
                onClick={() => setTheme(t.toLowerCase())}
                className={`flex-1 py-2 text-sm font-medium rounded-lg transition-all duration-200`}
                style={{
                  backgroundColor: theme === t.toLowerCase() ? 'var(--accent)' : 'transparent',
                  color: theme === t.toLowerCase() ? 'var(--foreground)' : 'var(--muted-foreground)',
                  boxShadow: theme === t.toLowerCase() ? '0 2px 8px rgba(0,0,0,0.2)' : 'none'
                }}
              >
                {t}
              </button>
            ))}
          </div>
        </div>

        {/* Toggle Section */}
        <div className="flex items-center justify-between py-4 group" style={{ borderTop: '1px solid var(--border)' }}>
          <div className="space-y-1">
            <p className="text-sm font-medium" style={{ color: 'var(--foreground)' }}>Auto-complete</p>
            <p className="text-xs" style={{ color: 'var(--muted-foreground)' }}>
              Show search suggestions as you type
            </p>
          </div>

          <Toggle enabled={autoComplete} setEnabled={setAutoComplete} />
        </div>
      </div>
    </div>
  )
}

function Toggle({ enabled, setEnabled }: { enabled: boolean; setEnabled: (v: boolean) => void }) {
  return (
    <button
      onClick={() => setEnabled(!enabled)}
      className="relative w-12 h-6 rounded-full transition-colors duration-300 outline-none"
      style={{
        backgroundColor: enabled ? 'var(--secondary)' : 'var(--input)',
        border: '1px solid var(--border)'
      }}
    >
      <div
        className="absolute top-[2px] w-4 h-4 rounded-full transition-all duration-300 ease-[cubic-bezier(0.34,1.56,0.64,1)]"
        style={{
          backgroundColor: '#fff', // High contrast for the knob
          left: enabled ? 'calc(100% - 18px)' : '4px',
          boxShadow: '0 2px 4px rgba(0,0,0,0.3)'
        }}
      />
    </button>
  )
}