"use client"
import React, { useState } from "react";
import { User, ShieldCheck, RefreshCw, ExternalLink, ArrowRight, LogIn, TrendingUp } from "lucide-react";
import { LoginModal } from "./LoginModal";
import { FullscreenPopup } from "@/components/ui/FullscreenPopup"
import { Portal } from "@/components/ui/Portal"
import { useAuth } from "@/components/auth-provider"
import { useRouter } from "next/navigation"
import { useSettings } from "@/context/SettingsContext";
export default function AdsCenter() {
    const [isLoggedIn, setIsLoggedIn] = useState(true);
    const [isModalOpen, setIsModalOpen] = useState(false);
    const router = useRouter()
    const { user, logout } = useAuth()
    const { tab, setTab } = useSettings();

    const handleLaunchAdsCenter = () => {
        if (user) {
            router.push("/ads-center")
            // setTab("You and Indzs")
            return null
        }else{
            setIsModalOpen(true)
        }
    }
    // if(user){
    // router.push("/ads-center")
    // setTab("You and Indzs")
    // return null
    // }
    return (
        <div className="w-full max-w-3xl mx-auto">
            <div
                className="rounded-3xl border overflow-hidden transition-all duration-500 shadow-xl"
                style={{ backgroundColor: 'var(--card)', borderColor: 'var(--border)', color: 'var(--card-foreground)' }}
            >
                {user ? (
                    /* --- LOGGED IN STATE --- */
                    <div className="p-5 sm:p-8 animate-in fade-in slide-in-from-bottom-2 duration-500">
                        <div className="flex flex-col [@media(min-width:900px)]:flex-row  [@media(min-width:900px)]:items-center justify-between gap-6 mb-8 sm:mb-10">
                            <div className="flex items-center gap-4 sm:gap-5">
                                <div className="relative shrink-0">
                                    <div className="w-14 h-14 sm:w-16 sm:h-16 rounded-2xl flex items-center justify-center text-xl sm:text-2xl font-bold shadow-lg ring-1 ring-white/10"
                                        style={{ backgroundColor: 'var(--sidebar)', color: 'var(--primary)' }}>
                                        {user.username.toUpperCase().charAt(0)}
                                    </div>
                                    <div className="absolute -bottom-1 -right-1 w-5 h-5 sm:w-6 sm:h-6 rounded-full border-4 flex items-center justify-center"
                                        style={{ backgroundColor: 'var(--chart-2)', borderColor: 'var(--card)' }}>
                                        <ShieldCheck size={10} className="text-black" />
                                    </div>
                                </div>
                                <div className="min-w-0">
                                    <h2 className="text-lg sm:text-xl font-bold tracking-tight truncate">{user.username}</h2>
                                    <p className="text-xs sm:text-sm opacity-60 truncate" style={{ color: 'var(--muted-foreground)' }}>
                                        {user.email}
                                    </p>
                                </div>
                            </div>

                            <div className="flex flex-row md:flex-row gap-2 sm:gap-3">
                                <button
                                    onClick={logout}
                                    className="flex-1 md:flex-none px-4 py-2.5 rounded-xl text-xs sm:text-sm font-medium transition-all border hover:bg-white/5 active:scale-95"
                                    style={{ borderColor: 'var(--border)' }}

                                >
                                    Sign out
                </button>
                                <button
                                    className="flex-[2] md:flex-none [@media(max-width:900px)]:flex-1  px-4 py-2.5 rounded-xl text-xs sm:text-sm font-medium transition-all shadow-md active:scale-95 flex items-center justify-center gap-2"
                                    style={{ backgroundColor: 'var(--primary)', color: 'var(--primary-foreground)' }}
                                >
                                    <RefreshCw size={14} className="shrink-0" /> Sync
                </button>
                            </div>
                        </div>

                        <div className="grid gap-2">

                            <div>
                                {<div className="p-8 sm:p-16 text-center animate-in fade-in duration-500">
                                    <div className="w-16 h-16 sm:w-20 sm:h-20 rounded-3xl flex items-center justify-center mx-auto mb-6 shadow-inner"
                                        style={{ backgroundColor: 'var(--muted)' }}>
                                        <TrendingUp size={32} className="sm:size-10" style={{ color: 'var(--muted-foreground)' }} />
                                    </div>
                                    <h2 className="text-2xl sm:text-3xl font-bold mb-3 tracking-tight">Control your advertising</h2>
                                    <p className="max-w-[280px] sm:max-w-xs mx-auto mb-8 text-xs sm:text-sm leading-relaxed" style={{ color: 'var(--muted-foreground)' }}>
                                        Access your dashboard to launch campaigns, track results, and optimize your ad performance.
            </p>
                                    <button
                                        onClick={() =>handleLaunchAdsCenter()}
                                        className="w-full sm:w-auto px-8 py-4 rounded-2xl font-bold flex items-center justify-center gap-3 mx-auto transition-all hover:scale-105 active:scale-95 shadow-xl text-sm sm:text-base"
                                        style={{ backgroundColor: 'var(--primary)', color: 'var(--primary-foreground)' }}
                                    >
                                        <LogIn size={20} />
              Launch Dashboard
            </button>
                                </div>}
                            </div>

                            {/* {[
                                { label: "Sync and Google services", icon: RefreshCw },
                                { label: "Manage your Account", icon: User },
                                { label: "Customize profile", icon: ExternalLink },
                                { label: "Import data", icon: ExternalLink },
                            ].map((item, i) => (
                                <div
                                    key={i}
                                    className="group flex items-center justify-between p-3.5 sm:p-4 rounded-2xl transition-all border border-transparent hover:border-white/5 cursor-pointer active:scale-[0.99]"
                                    style={{ backgroundColor: 'var(--input)' }}
                                >
                                    <div className="flex items-center gap-3 min-w-0">
                                        <item.icon size={18} className="opacity-60 shrink-0" />
                                        <span className="text-xs sm:text-sm font-medium truncate">{item.label}</span>
                                    </div>
                                    <ArrowRight size={16} className="opacity-40 sm:opacity-0 -translate-x-2 group-hover:opacity-100 group-hover:translate-x-0 transition-all shrink-0" />
                                </div>
                            ))} */}
                        </div>
                    </div>
                ) : (
                        /* --- LOGGED OUT STATE --- */
                        <div>
                            { <div className="p-8 sm:p-16 text-center animate-in fade-in duration-500">
                                <div className="w-16 h-16 sm:w-20 sm:h-20 rounded-3xl flex items-center justify-center mx-auto mb-6 shadow-inner"
                                    style={{ backgroundColor: 'var(--muted)' }}>
                                    <TrendingUp size={32} className="sm:size-10" style={{ color: 'var(--muted-foreground)' }} />
                                </div>
                                <h2 className="text-2xl sm:text-3xl font-bold mb-3 tracking-tight">Control your advertising</h2>
                                <p className="max-w-[280px] sm:max-w-xs mx-auto mb-8 text-xs sm:text-sm leading-relaxed" style={{ color: 'var(--muted-foreground)' }}>
                                    Sign in to launch campaigns, track results, and optimize your ad performance.
            </p>
                                <button
                                    onClick={() => setIsModalOpen(true)}
                                    className="w-full sm:w-auto px-8 py-4 rounded-2xl font-bold flex items-center justify-center gap-3 mx-auto transition-all hover:scale-105 active:scale-95 shadow-xl text-sm sm:text-base"
                                    style={{ backgroundColor: 'var(--primary)', color: 'var(--primary-foreground)' }}
                                >
                                    <LogIn size={20} />
              Sign in to Indzs
            </button>
                            </div>}
                        </div>
                    )}
            </div>

            {/* <FullscreenPopup/> */}
            <Portal>
                {isModalOpen && <div className="fixed inset-0 z-[9999] bg-black/80 backdrop-blur-lg">
                    <LoginModal
                        isOpen={isModalOpen}
                        onClose={() => setIsModalOpen(false)}
                        onLogin={() => { setIsLoggedIn(true); setIsModalOpen(false); }}
                    />
                </div>}
            </Portal>
        </div>
    );
}