export default function GoogleLikeLayout() {
  return (
    <div className="min-h-screen bg-white relative">

      {/* ---------- Top Header ---------- */}
      <header className="absolute top-0 right-0 left-0">
        <div className="flex justify-end items-center gap-4 px-6 py-4">
          <a href="#" className="text-sm text-gray-700 hover:underline">
            Gmail
          </a>
          <a href="#" className="text-sm text-gray-700 hover:underline">
            Images
          </a>

          {/* Apps Icon */}
          <button className="p-2 rounded-full hover:bg-gray-100">
            <svg className="w-5 h-5 text-gray-700" viewBox="0 0 24 24">
              <circle cx="5" cy="5" r="2" />
              <circle cx="12" cy="5" r="2" />
              <circle cx="19" cy="5" r="2" />
              <circle cx="5" cy="12" r="2" />
              <circle cx="12" cy="12" r="2" />
              <circle cx="19" cy="12" r="2" />
              <circle cx="5" cy="19" r="2" />
              <circle cx="12" cy="19" r="2" />
              <circle cx="19" cy="19" r="2" />
            </svg>
          </button>

          {/* Profile */}
          <div className="w-8 h-8 rounded-full bg-green-600 text-white flex items-center justify-center text-sm font-medium">
            A
          </div>
        </div>
      </header>

      {/* ---------- Center Content ---------- */}
      <main className="flex flex-col items-center justify-center min-h-screen -mt-16">

        {/* Logo */}
        <div className="mb-8">
          {/* <LogoWithText size="lg" /> */}
        </div>

        {/* Search Bar */}
        <div className="w-full px-4">
          <div className="mx-auto max-w-[584px]">
            <SearchWithAutocomplete
              value={query}
              onChange={setQuery}
              onSubmit={handleSearch}
              placeholder="Search Google or type a URL"
              size="lg"
              showButton={false}
              className="google-search-input"
            />
          </div>
        </div>

        {/* Buttons */}
        <div className="flex gap-3 mt-8">
          <button className="google-btn">Google Search</button>
          <button className="google-btn">I'm Feeling Lucky</button>
        </div>

      </main>
    </div>
  )
}
