"use client"

import React from 'react';
import { Sparkles, ArrowUpRight, Copy, RotateCcw, Share2, thumbsUp } from 'lucide-react';

import { useState, useEffect } from "react";
import { copyToClipboard } from "@/lib/copyToClipboard";

interface ApiResponse {
  title: string;
  summary: string;
  description?: string;
  pageUrl?: string;
}
export default function AiSearchResult({ query, search, answer = [] }) { //{ query, answer, sources }
  // const [query, setQuery] = useState("");
  const [summary, setSummary] = useState<string | null>(null);
  const [sources, setSources] = useState<Object | null>(null)
  const [error, setError] = useState<string | null>(null);
  const [copied, setCopied] = useState(false);
  const [summaryData, setSummaryData] = useState<ApiResponse | null>(null)
  const handleCopy = async () => {
    const success = await copyToClipboard(summary || '');

    if (success) {
      // alert("Copied to clipboard!");
      setCopied(success);
      setTimeout(() => setCopied(false), 2000);
    } else {
      // alert("Copy failed");
    }
  };

  const handleShare = async () => {
    if (!summaryData) return;

    // Search result powered by INDZS
    const shareText = `${summaryData.title}${summaryData.description ? ` ${summaryData.description}` : ""} 
${summaryData.summary} 
Search on INDZS: https://indzs.com/search?q=${query}
`;
    // Read more: ${summaryData.pageUrl}

    console.log(shareText)
    // return
    // 1️⃣ Native share (mobile + supported browsers)
    if (navigator.share) {
      try {
        await navigator.share({
          title: summaryData.title,
          text: shareText,
          url: summaryData.pageUrl,
        });
      } catch (err) {
        console.error("Share cancelled", err);
      }
      return;
    }
  }

  const fetchSummary = async () => {
    setError(null);
    setSummary(null);

    try {
      console.log("fetching")
      const res = await fetch(`/api/wikipedia-summary?q=${encodeURIComponent(query)}`);
      const data = await res.json();

      if (!res.ok) {
        setError(data.error || "Something went wrong");
      } else {
        setSummaryData(data)
        setSummary(data.summary);
        setSources([{
          title: "Wikipedia",
          url: data.pageUrl
        }])
        // setSummary(null)
      }
    } catch (err) {
      setError("Failed to fetch summary");
    }
  };
  useEffect(() => {
    fetchSummary()
  }, [search])

  // <div className="w-full max-w-3xl mx-auto my-8 animate-in fade-in slide-in-from-bottom-4 duration-700"></div>
  return (
    <>
      {!summary && <></>}
      {summary && <div className="max-w-3xl my-8 animate-in fade-in slide-in-from-bottom-4 duration-700">
        {/* Container with subtle glass effect and variable border */}
        {/* <div className="relative overflow-hidden rounded-[32px]  bg-[oklch(from_var(--card)_l_c_h_/_0.5)] backdrop-blur-xl"> */}

        <div className="relative overflow-hidden   backdrop-blur-xl">

          {/* Animated Gradient Beam (Animate-UI signature) */}
          {/* <div className="absolute top-0 left-0 w-full h-[1px] bg-gradient-to-r from-transparent via-[var(--primary)] to-transparent opacity-20" /> */}

          {/* Header Section */}
          <div className=" flex items-center justify-between">
            <div className="flex items-center gap-2.5">
              <div className="p-1.5 rounded-lg bg-[var(--primary)] text-[var(--primary-foreground)] shadow-[0_0_15px_oklch(from_var(--primary)_l_c_h_/_0.3)]">
                <Sparkles className="w-4 h-4" />
              </div>
              <h2 className="text-xs font-bold uppercase tracking-[0.2em] text-[var(--muted-foreground)]">
                AI Insight
            </h2>
            </div>

            <div className="flex items-center gap-1">
              <button className="p-2 rounded-full hover:bg-[var(--secondary)] text-[var(--muted-foreground)] hover:text-[var(--foreground)] transition-colors"
                onClick={handleShare}
              >
                <Share2 className="w-3.5 h-3.5" />
              </button>
              <button className="p-2 rounded-full hover:bg-[var(--secondary)] text-[var(--muted-foreground)] hover:text-[var(--foreground)] transition-colors">
                <RotateCcw className="w-3.5 h-3.5" />
              </button>
            </div>
          </div>

          {/* Content Section */}
          <div className=" py-6 space-y-6">
            <div className="prose prose-invert max-w-none">
              <p className="text-[15px] leading-[1.6] text-[var(--foreground)] font-medium opacity-90">
                {summary || "Analyzing your request to provide the most accurate synthesis of information..."}
              </p>
            </div>

            {/* Sources Section: Horizontal pill layout */}
            <div className="space-y-3 pt-2">
              <p className="text-[10px] font-bold uppercase tracking-widest text-[var(--muted-foreground)] ml-1">
                Verified Sources
            </p>

              <div className="flex flex-wrap gap-2">
                {sources?.map((source, i) => (
                  <a
                    key={i}
                    href={source.url}
                    className="group flex items-center gap-2 px-3 py-1.5 rounded-full bg-[var(--secondary)] border border-[var(--border)] hover:border-[var(--primary)]/30 transition-all"
                    target="_blank"
                  >
                    <div className="w-4 h-4 rounded-full bg-[var(--background)] flex items-center justify-center text-[10px] font-bold border border-[var(--border)] group-hover:border-[var(--primary)]/20">
                      {i + 1}
                    </div>
                    <span className="text-xs font-medium text-[var(--foreground)] group-hover:text-[var(--foreground)] truncate max-w-[120px] text-white">
                      {source.title}
                    </span>
                    <ArrowUpRight className="w-3 h-3 text-[var(--foreground)] opacity-0 -translate-y-1 translate-x-1 group-hover:opacity-100 group-hover:translate-y-0 group-hover:translate-x-0 transition-all" />
                  </a>
                ))}
              </div>
            </div>
          </div>

          {/* Footer Actions */}
          <div className=" py-4 bg-[oklch(from_var(--secondary)_l_c_h_/_0.0)] border-t border-[var(--border)] flex items-center justify-between">

            <div className="flex gap-4">
              <button className="flex items-center gap-2 text-[11px] font-bold text-[var(--muted-foreground)] hover:text-[var(--foreground)] transition-colors uppercase tracking-wider"
                onClick={handleCopy}
              >
                <Copy className="w-3.5 h-3.5" />
                {copied ? "Copied!" : "Copy"}
              </button>
            </div>

            <div className="flex items-center gap-3">
              <span className="text-[10px] font-medium text-[var(--muted-foreground)]">Was this helpful?</span>
              <div className="flex gap-1">
                <button className="p-1.5 rounded-md hover:bg-[var(--background)] border border-transparent hover:border-[var(--border)] transition-all">
                  <svg className="w-3.5 h-3.5 text-[var(--muted-foreground)]" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2.5} d="M14 10h4.757c1.246 0 2.254 1.008 2.254 2.254 0 .393-.104.782-.303 1.123l-3.236 5.547c-.394.676-1.117 1.076-1.902 1.076H7.318c-1.278 0-2.318-1.04-2.318-2.318V10c0-.615.244-1.205.679-1.64l6.14-6.141c.365-.365.945-.386 1.336-.048.331.286.435.753.255 1.15L11.83 8h5.424C18.499 8 19.5 9.001 19.5 10.254v.492" /></svg>
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>}
    </>
  );
}