import React from 'react';
import LegalTemplate from '@/components/LegalTemplate'
const termsData = {

    "title": "Privacy Policy",
    "lastUpdated": "January 04, 2026",
    "sections": [
        {
            "id": "collection",
            "heading": "1. Data Collection",
            "content": "We limit data collection to the absolute bare minimum required to provide a functional search experience.",
            "list": [
                "Search queries are anonymized within 24 hours.",
                "We do not track IP addresses beyond security logging.",
                "No third-party tracking cookies are ever deployed."
            ],
            "highlight": "Note: Our Neural Search model processes data locally whenever possible to ensure maximum user privacy."
        },
        {
            "id": "sharing",
            "heading": "2. Information Sharing",
            "content": "We do not sell, rent, or trade your personal data with third parties for marketing purposes. Data is only shared when legally compelled by a valid court order.",
            "highlight": "Note: Our Neural Search model processes data locally whenever possible to ensure maximum user privacy."
        }
    ]
}

export default function PrivacyPage() {
    return <LegalTemplate data={termsData} />;
}