"use client"

import { useState, useEffect } from "react"
import { Search, ImageIcon, Video, Settings, Moon, Sun, Plus, User, LogOut, ChevronDown } from "lucide-react"
import { Button } from "@/components/ui/button"
import { useRouter } from "next/navigation"
import { Logo, LogoWithText, LogoTM } from "@/components/logo"
import { SearchWithAutocomplete } from "@/components/search-with-autocomplete"
import { useTheme } from "@/components/theme-provider"
import { useAuth } from "@/components/auth-provider"
import { Dialog, DialogContent, DialogHeader, DialogTitle, DialogTrigger } from "@/components/ui/dialog"
import QuickLinks from "@/components/ui/QuickLinks"
import { useSearchHistory } from "@/hooks/useSearchHistory"
import { MinimalHeader } from "@/components/ui/MinimalHeader"
import Header from "@/components/ui/Header"
import { useHistory } from '@/hooks/useHistory'
import Footer from '@/components/ui/Footer'
interface SiteSettings {
  siteName: string
  siteTitle: string
  siteDescription: string
  welcomeMessage: string
  popularSearches: string[]
  showSubmitWebsite: boolean
  logo: string
  favicon: string
  themeColor: string
}

export default function HomePage() {
  const [query, setQuery] = useState("")
  const [isAccountModalOpen, setIsAccountModalOpen] = useState(false)
  const [siteSettings, setSiteSettings] = useState<SiteSettings>({
    siteName: "Indzs Search",
    siteTitle: "Indzs Search - Fast, Comprehensive Search Engine",
    siteDescription: "Search the web with Indzs Search",
    welcomeMessage: "Fast, comprehensive search across the web",
    popularSearches: ["Technology", "News", "Weather", "Sports", "Entertainment"],
    showSubmitWebsite: true,
    logo: "/logo.png",
    favicon: "/favicon.ico",
    // themeColor: "#10b981",
    themeColor: '#df7016'
  })
  const router = useRouter()
  const { theme, setTheme, setThemeColor } = useTheme()
  const { user, logout } = useAuth()

  const [mounted, setMounted] = useState(false)
  const { history, addToHistory, deleteFromHistory } = useSearchHistory();
  const [isMenuOpen, setIsMenuOpen] = useState(false);
  const { saveSearchHistory } = useHistory();
  useEffect(() => {
    setMounted(true)
    fetchSiteSettings()

    const interval = setInterval(fetchSiteSettings, 30000)
    return () => clearInterval(interval)
  }, [])

  const fetchSiteSettings = async () => {
    try {
      console.log("[v0] Fetching site settings...")
      const response = await fetch("/api/admin/site-settings", {
        cache: "no-store",
        headers: {
          "Cache-Control": "no-cache",
        },
      })
      if (response.ok) {
        const settings = await response.json()
        console.log("[v0] Received site settings:", settings)
        setSiteSettings(settings)

        if (settings.themeColor && settings.themeColor !== siteSettings.themeColor) {
          setThemeColor(settings.themeColor)
        }
      } else {
        console.error("[v0] Failed to fetch site settings:", response.status, response.statusText)
      }
    } catch (error) {
      console.error("[v0] Failed to fetch site settings:", error)
    }
  }

  const handleSearch = (searchQuery: string) => {
    if (searchQuery.trim()) {
      saveSearchHistory(
        {
          query : searchQuery,
          type: "web",
        }
      );
      router.push(`/search?q=${encodeURIComponent(searchQuery.trim())}&type=web`)
    }
  }

  const toggleTheme = () => {
    if (theme === "light") {
      setTheme("dark")
    } else if (theme === "dark") {
      setTheme("system")
    } else {
      setTheme("light")
    }
  }

  const getThemeIcon = () => {
    if (!mounted) {
      return <Moon className="w-4 h-4" />
    }
    if (theme === "light") return <Moon className="w-4 h-4" />
    if (theme === "dark") return <Sun className="w-4 h-4" />
    return <Moon className="w-4 h-4" />
  }

  const handleAccountClick = () => {
    setIsAccountModalOpen(false)
    router.push("/account")
  }

  const handleLogout = () => {
    setIsAccountModalOpen(false)
    logout()
  }

  return (
    <div className="min-h-screen bg-background flex flex-col home-page-container">
      <Header />
      {/* Header */}
      {/* <header className="flex justify-between items-center p-4 relative z-10">
        <LogoWithText size="sm" siteSettings={siteSettings} />
        <div className="flex items-center gap-2">
          <Button
            variant="ghost"
            size="sm"
            onClick={toggleTheme}
            className="cursor-pointer hover:bg-accent hover:text-accent-foreground transition-colors bg-background/80 backdrop-blur-sm border border-border/50"
          >
            {getThemeIcon()}
          </Button>
          {user && siteSettings.showSubmitWebsite && (
            <Button
              variant="ghost"
              size="sm"
              onClick={() => router.push("/submit-website")}
              className="cursor-pointer hover:bg-accent hover:text-accent-foreground transition-colors bg-background/80 backdrop-blur-sm border border-border/50"
            >
              <Plus className="w-4 h-4" />
            </Button>
          )}

          {user ? (
            <Dialog open={isAccountModalOpen} onOpenChange={setIsAccountModalOpen}>
              <DialogTrigger asChild>
                <Button
                  variant="ghost"
                  size="sm"
                  className="cursor-pointer hover:bg-accent hover:text-accent-foreground transition-colors bg-background/80 backdrop-blur-sm border border-border/50"
                >
                  <User className="w-4 h-4 mr-2" />
                  {user.username}
                </Button>
              </DialogTrigger>
              <DialogContent className="sm:max-w-md">
                <DialogHeader>
                  <DialogTitle className="flex items-center gap-2">
                    <User className="w-5 h-5" />
                    Account Menu
                  </DialogTitle>
                </DialogHeader>
                <div className="flex flex-col gap-3 pt-4">
                  <div className="text-sm text-muted-foreground mb-2">
                    Logged in as: <span className="font-medium text-foreground">{user.username}</span>
                  </div>
                  <Button variant="outline" className="justify-start bg-transparent" onClick={handleAccountClick}>
                    <User className="w-4 h-4 mr-2" />
                    Account Settings
                  </Button>
                  <Button variant="outline" className="justify-start bg-transparent" onClick={handleLogout}>
                    <LogOut className="w-4 h-4 mr-2" />
                    Logout
                  </Button>
                </div>
              </DialogContent>
            </Dialog>
          ) : (
            <Button
              variant="ghost"
              size="sm"
              onClick={() => router.push("/ads-center/auth")}
              className="cursor-pointer hover:bg-accent hover:text-accent-foreground transition-colors bg-background/80 backdrop-blur-sm border border-border/50"
            >
              <User className="w-4 h-4 mr-2" />
              Sign In
            </Button>
          )}

          <Button
            variant="ghost"
            size="sm"
            onClick={() => router.push("/settings")}
            className="bg-background/80 backdrop-blur-sm border border-border/50 hover:bg-accent hover:text-accent-foreground transition-colors cursor-pointer"
          >
            <Settings className="w-4 h-4" />
          </Button>
        </div>
      </header> */}
      {/* <header className="sticky top-0 flex items-center justify-between px-6 py-4 bg-background/60 backdrop-blur-md z-10">
        <div className="flex items-center cursor-pointer hover:opacity-70 transition-opacity">
          <Logo size="md" siteSettings={siteSettings} />
        </div>

  
        <nav className="flex items-center gap-1 p-1.5 rounded-full border border-border/40 bg-secondary/20 shadow-sm">

         
          <button
            onClick={toggleTheme}
            className="p-2 rounded-full hover:bg-accent text-foreground/70 hover:text-foreground transition-all"
          >
         
            {getThemeIcon()}
          </button>

          {user && siteSettings.showSubmitWebsite && (
            <button
    
              onClick={() => router.push("/settings?tab=Submit%20Website")}

              
              className="p-2 rounded-full hover:bg-accent text-foreground/70 hover:text-foreground transition-all"
            >
              <Plus size={18} />
            </button>
          )}


          <div className="w-[1px] h-4 bg-border/60 mx-1" />


          <div className="relative">
            {user ? (
              <>
                <button
                  onClick={() => setIsMenuOpen(!isMenuOpen)}
                  className="flex items-center gap-2 px-3 py-1.5 rounded-full hover:bg-accent transition-all"
                >
                  <div className="w-6 h-6 rounded-full bg-primary flex items-center justify-center">
                    <User size={14} className="text-primary-foreground" />
                  </div>
                  <span className="text-sm font-medium hidden sm:block">Namaste , {user.username.toUpperCase().charAt(0)}</span>
                  <ChevronDown size={14} className={`transition-transform ${isMenuOpen ? 'rotate-180' : ''}`} />
                </button>


                {isMenuOpen && (
                  <div className="absolute right-0 mt-3 w-48 overflow-hidden rounded-2xl border border-border bg-popover shadow-xl animate-in fade-in zoom-in duration-150">
                    <div className="p-3 border-b border-border/50">
                      <p className="text-[10px] uppercase tracking-widest text-muted-foreground font-semibold">Account</p>
                      <p className="text-sm truncate font-medium">{user.username}</p>
                    </div>
                    <div className="p-1">
                      <button className="flex w-full items-center gap-2 px-3 py-2 text-sm rounded-lg hover:bg-accent transition-colors"
                      
                      
                      onClick={() => router.push("/settings")

                        
                      }
                      >
                        <Settings size={14} /> Settings
                    </button>
                      <button className="flex w-full items-center gap-2 px-3 py-2 text-sm rounded-lg hover:bg-destructive/10 text-destructive transition-colors"
                      style={{color:'red'}}
                      onClick={logout}
                      >
                        
                        <LogOut size={14} /> Logout
                    </button>
                    </div>
                  </div>
                )}
              </>
            ) : (
                <button
                  onClick={() => router.push("/settings")}
                  className="flex items-center gap-2 px-4 py-1.5 text-sm font-medium rounded-full bg-primary text-primary-foreground hover:opacity-90 transition-opacity"
                >
                  Sign In
                </button>
              )}
          </div>


          <button
            onClick={() => router.push("/settings")}
            className="p-2 rounded-full hover:bg-accent text-foreground/70 hover:text-foreground transition-all"
          >
            <Settings size={18} />
          </button>
        </nav>
      </header> */}


      {/* Main Content */}
      <main className="flex-1 flex flex-col items-center justify-center px-4 -mt-20 relative indzs-search-wrapper">
        {/* Logo */}
        <div className="mb-8 text-center flex flex-col" style={{alignItems: 'center'}}>
          {/* <Logo size="lg" className="mb-4 mx-auto shadow-lg" siteSettings={siteSettings} /> */}
          {/* <Logo size="lg" className="mx-auto" siteSettings={siteSettings} /> */}

          {/* <h1 className="text-4xl font-bold text-foreground mb-2">{siteSettings.siteName}</h1> */}
          <LogoTM size="xl2" siteSettings={siteSettings}></LogoTM>
          <p className="text-muted-foreground">{siteSettings.welcomeMessage}</p>
          {user && (
            <p className="text-sm text-primary mt-2">
              Welcome back, {user.username}! Ready to advertise?{" "}
              <button onClick={() => router.push("/ads-center")} className="underline hover:text-primary/80">
                Visit Ads Center
              </button>
            </p>
          )}
        </div>

        {/* Search Form */}
        <div className="w-full max-w-2xl mb-8 relative isolate z-1">
          <SearchWithAutocomplete
            value={query}
            onChange={setQuery}
            onSubmit={handleSearch}
            placeholder="Search for anything"
            size="lg"
            showButton={true}
            buttonText="Search"
            className="placeholder:text-gray-400"
          />

        </div>

        {/* Search Type Buttons */}
        {/* <div className="flex gap-4 mb-8">
          <Button
            variant="outline"
            className="flex items-center gap-2 rounded-full bg-background/80 backdrop-blur-sm border-border/50 text-foreground hover:bg-accent hover:text-accent-foreground"
            onClick={() => query && router.push(`/search?q=${encodeURIComponent(query)}&type=web`)}
          >
            <Search className="w-4 h-4 text-foreground" />
            Web
          </Button>
          <Button
            variant="outline"
            className="flex items-center gap-2 rounded-full bg-background/80 backdrop-blur-sm border-border/50 text-foreground hover:bg-accent hover:text-accent-foreground"
            onClick={() => query && router.push(`/search?q=${encodeURIComponent(query)}&type=images`)}
          >
            <ImageIcon className="w-4 h-4 text-foreground" />
            Images
          </Button>
          <Button
            variant="outline"
            className="flex items-center gap-2 rounded-full bg-background/80 backdrop-blur-sm border-border/50 text-foreground hover:bg-accent hover:text-accent-foreground"
            onClick={() => query && router.push(`/search?q=${encodeURIComponent(query)}&type=videos`)}
          >
            <Video className="w-4 h-4 text-foreground" />
            Videos
          </Button>
        </div> */}

        {/* Quick Links */}
        {/* {siteSettings.popularSearches.length > 0 && (
          <div className="text-center">
            <p className="text-sm text-muted-foreground mb-2">Popular searches:</p>
            <div className="flex flex-wrap gap-2 justify-center">
              {siteSettings.popularSearches.map((term) => (
                <Button
                  key={term}
                  variant="ghost"
                  size="sm"
                  className="text-foreground hover:text-accent-foreground hover:bg-accent rounded-full"
                  onClick={() => {
                    setQuery(term)
                    handleSearch(term)
                  }}
                >
                  {term}
                </Button>
              ))}
            </div>
            <div className="mt-2 text-xs text-muted-foreground">Last updated: {new Date().toLocaleTimeString()}</div>
          </div>
        )} */}
        <QuickLinks />
      </main>

      {/* Footer border-t*/}
      <footer className="p-4 text-center text-sm text-muted-foreground  border-border">
        <p>
          &copy; {new Date().getFullYear()} {siteSettings.siteName}. {siteSettings.siteDescription}
        </p>
      </footer>
      {/* <Footer/> */}
    </div>
  )
}
