'use client';

import { useEffect } from 'react';
import { useSearchParams } from 'next/navigation';
import { getEngine } from '@/lib/engines';
import SearchTabs from '@/components/ui/GoogleSearchTabs';

export default function SearchPage() {
    const params = useSearchParams();
    const q = params.get('q');
    const type = params.get('type') || 'web';
    const engine = getEngine(type);

    useEffect(() => {
        if (!q) return;

        const old = document.getElementById('google-cse');
        if (old) old.remove();

        const script = document.createElement('script');
        script.id = 'google-cse';
        script.async = true;
        script.src = `https://cse.google.com/cse.js?cx=${engine.cx}`;

        document.body.appendChild(script);
    }, [engine.cx, q]);

    if (!q) return null;

    return (
        <div className="max-w-6xl mx-auto px-4 py-6">
            <SearchTabs />

            <div
                className="gcse-searchresults-only"
                data-enableimagesearch="true"
  data-defaulttoimagesearch="true"
  
                // data-safesearch="moderate"
                // data-linktarget="_blank"
                // data-enableimagesearch="false"
                // data-websearchresultsetsize="10"
                // data-defaulttoimagesearch="true"
            />
        </div>
    );
}
