import { type NextRequest, NextResponse } from "next/server"
import { submitWebsitesBulk } from "@/lib/submitWebsitesBulk"
import { normalizeWebsites } from "@/lib/normalizeWebsites"

const ADMIN_KEY = process.env.ADMIN_BULK_SUBMIT_KEY

export async function POST(request: NextRequest) {
  try {
    // 🔐 Simple API key protection
    const adminKey = request.headers.get("x-admin-key")
    if (!ADMIN_KEY || adminKey !== ADMIN_KEY) {
      return NextResponse.json(
        { error: "Unauthorized access" },
        { status: 401 }
      )
    }

    const body = await request.json()
    const normalized = normalizeWebsites(body.websites || [])
    console.log(normalized)

    if (!Array.isArray(normalized) || normalized.length === 0) {
      return NextResponse.json(
        { error: "Invalid or empty websites array" },
        { status: 400 }
      )
    }

    // Validate each item
    const validWebsites = normalized.filter((site) => {
      try {
        return (
          site.title &&
          site.url &&
          site.ownerConfirmed === true &&
          new URL(site.url)
        )
      } catch {
        return false
      }
    })

    if (validWebsites.length === 0) {
      return NextResponse.json(
        { error: "No valid websites found" },
        { status: 400 }
      )
    }

    const result = await submitWebsitesBulk(validWebsites)



    // if (!Array.isArray(body.websites) || body.websites.length === 0) {
    //   return NextResponse.json(
    //     { error: "Invalid or empty websites array" },
    //     { status: 400 }
    //   )
    // }

    // // Validate each item
    // const validWebsites = body.websites.filter((site) => {
    //   try {
    //     return (
    //       site.title &&
    //       site.url &&
    //       site.ownerConfirmed === true &&
    //       new URL(site.url)
    //     )
    //   } catch {
    //     return false
    //   }
    // })

    // if (validWebsites.length === 0) {
    //   return NextResponse.json(
    //     { error: "No valid websites found" },
    //     { status: 400 }
    //   )
    // }

    // const result = await submitWebsitesBulk(validWebsites)

    return NextResponse.json({
      success: true,
      submitted: result.successCount,
      successCount: result.successCount,
      failedCount: result.failedCount,
      skippedCount: result.skippedCount
    })
  } catch (error) {
    console.error("[BULK SUBMIT] Error:", error)
    return NextResponse.json(
      { error: "Bulk submission failed" },
      { status: 500 }
    )
  }
}
