import { type NextRequest, NextResponse } from "next/server"
import { createWalletTransactionsCollection } from "@/lib/typesense"
import { client } from "@/lib/typesense"

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const userId = searchParams.get("userId")

    if (!userId) {
      return NextResponse.json({ error: "User ID is required" }, { status: 400 })
    }

    await createWalletTransactionsCollection()

    const searchResults = await client
      .collections("wallet_transactions")
      .documents()
      .search({
        q: "*",
        filter_by: `userId:=${userId}`,
        per_page: 50,
      })

    const transactions = searchResults.hits?.map((hit: any) => hit.document) || []

    return NextResponse.json({ transactions })
  } catch (error) {
    console.error("Error fetching wallet transactions:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
