import { type NextRequest, NextResponse } from "next/server"
import { updateUserWallet } from "@/lib/typesense"

export async function POST(request: NextRequest) {
  try {
    const { userId, amount, razorpayPaymentId, razorpayOrderId, razorpaySignature } = await request.json()

    if (!userId || !amount || !razorpayPaymentId) {
      return NextResponse.json({ error: "Missing required fields" }, { status: 400 })
    }

    // In a real implementation, you would verify the Razorpay signature here
    // const isValidSignature = verifyRazorpaySignature(razorpayOrderId, razorpayPaymentId, razorpaySignature)
    // if (!isValidSignature) {
    //   return NextResponse.json({ error: "Invalid payment signature" }, { status: 400 })
    // }

    const newBalance = await updateUserWallet(
      userId,
      amount,
      "credit",
      `Wallet top-up via Razorpay`,
      undefined,
      razorpayPaymentId,
    )

    return NextResponse.json({
      success: true,
      newBalance,
      message: "Funds added successfully",
    })
  } catch (error) {
    console.error("Error adding funds:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
