import { NextResponse } from "next/server"
import { getAllSiteSettings } from "@/lib/typesense"

export async function GET() {
  try {
    const settings = await getAllSiteSettings()
    return NextResponse.json(settings)
  } catch (error) {
    console.error("[API] Error fetching site settings:", error)
    return NextResponse.json({ error: "Failed to fetch site settings" }, { status: 500 })
  }
}
