import { NextRequest, NextResponse } from "next/server"
import { submitImagesBulk } from "@/lib/submitImagesBulk"

export async function POST(req: NextRequest) {
  try {
    const data = await req.json()

    const result = await submitImagesBulk(data)

    return NextResponse.json({
      success: true,
      ...result,
    })
  } catch (error) {
    console.error("[IMAGE BULK SEED ERROR]", error)

    return NextResponse.json(
      {
        success: false,
        error: error instanceof Error ? error.message : "Unknown error",
      },
      { status: 500 },
    )
  }
}




// import { NextRequest, NextResponse } from "next/server"
// import typesenseClient from "@/lib/typesense"



// const IMAGE_COLLECTION = "image_results"
// const COLLECTION = IMAGE_COLLECTION

// const imageSchema = {
//     name: IMAGE_COLLECTION,
//     fields: [
//         { name: "title", type: "string" },
//         { name: "url", type: "string" },
//         { name: "imgurl", type: "string" },
//         { name: "keywords", type: "string[]", optional: true },
//         { name: "date", type: "string", optional: true },
//         { name: "safesearch", type: "bool" },
//         { name: "favicon", type: "string", optional: true },
//     ],
// }

// const CHUNK_SIZE = 1000

// /* ------------------ Ensure Collection ------------------ */
// async function ensureCollection() {
//     try {
//         await typesenseClient.collections(COLLECTION).retrieve()
//     } catch {
//         await typesenseClient.collections().create({
//             name: COLLECTION,
//             fields: [
//                 { name: "title", type: "string" },
//                 { name: "url", type: "string" },
//                 { name: "imgurl", type: "string" },
//                 { name: "keywords", type: "string[]", optional: true },
//                 { name: "date", type: "string", optional: true },
//                 { name: "safesearch", type: "bool" },
//                 { name: "favicon", type: "string", optional: true },
//             ],
//         })
//     }
// }

// /* ------------------ Helpers ------------------ */
// function normalizeUrl(url: string) {
//     if (!url) return ""
//     return url.startsWith("http") ? url : `https://${url}`
// }

// function normalizeDoc(doc: any) {
//     const img = doc.imgurl || doc.image
//     if (!doc.title || !img || !doc.url) return null

//     return {
//         title: String(doc.title),
//         imgurl: String(img),
//         url: normalizeUrl(doc.url),
//         keywords: Array.isArray(doc.keywords) ? doc.keywords : [],
//         safesearch: true,
//         favicon: doc.favicon || undefined,
//     }
// }

// function chunk<T>(arr: T[], size: number) {
//     const chunks = []
//     for (let i = 0; i < arr.length; i += size) {
//         chunks.push(arr.slice(i, i + size))
//     }
//     return chunks
// }

// /* ------------------ Route ------------------ */
// export async function POST(req: NextRequest) {
//     try {
//         const data = await req.json()
//         console.log(data)
//         // return NextResponse.json(
//         //     { success: false, error: "Expected an array of image objects" },
//         //     { status: 400 },
//         //   )
//         // if (!data?.images) {
//         //     return NextResponse.json(
//         //         { success: false, error: "Expected an array of image objects" },
//         //         { status: 400 },
//         //     )
//         // }
//         if (!Array.isArray(data)) {
//             return NextResponse.json(
//                 { success: false, error: "Expected an array of image objects" },
//                 { status: 400 },
//             )
//         }

//         await ensureCollection()

//         /* ---- Normalize + Deduplicate by imgurl ---- */
//         const seen = new Set<string>()
//         const docs = []

//         for (const item of data) {
//             const doc = normalizeDoc(item)
//             if (!doc) continue

//             if (!seen.has(doc.imgurl)) {
//                 seen.add(doc.imgurl)
//                 docs.push(doc)
//             }
//         }

//         const chunks = chunk(docs, CHUNK_SIZE)

//         let imported = 0
//         let failed = 0

//         for (const batch of chunks) {
//             const res = await typesenseClient
//                 .collections(COLLECTION)
//                 .documents()
//                 .import(batch, { action: "upsert" })

//             // res.split("\n").forEach((line) => {
//             //     const r = JSON.parse(line)
//             //     r.success ? imported++ : failed++
//             // })

//             const results = Array.isArray(res)
//                 ? res
//                 : res
//                     .split("\n")
//                     .map((line: string) => JSON.parse(line))

//             for (const r of results) {
//                 r.success ? imported++ : failed++
//             }
//         }

//         return NextResponse.json({
//             success: true,
//             received: data.length,
//             uniqueImages: docs.length,
//             imported,
//             failed,
//         })
//     } catch (err) {
//         console.error("[IMAGE BULK SEED ERROR]", err)
//         return NextResponse.json(
//             {
//                 success: false,
//                 error: err instanceof Error ? err.message : "Unknown error",
//             },
//             { status: 500 },
//         )
//     }
// }
