import { NextResponse } from "next/server"

interface HomepageSettings {
  popularSearches: string[]
  welcomeMessage: string
  showSubmitWebsite: boolean
}

// Default settings
const defaultSettings: HomepageSettings = {
  popularSearches: ["Technology", "News", "Weather", "Sports", "Entertainment"],
  welcomeMessage: "Fast, comprehensive search across the web",
  showSubmitWebsite: true,
}

export async function GET() {
  try {
    const adminResponse = await fetch(
      `${process.env.NEXT_PUBLIC_APP_URL || "http://localhost:3000"}/api/admin/homepage-settings`,
      {
        method: "GET",
        headers: {
          "Content-Type": "application/json",
        },
      },
    )

    if (adminResponse.ok) {
      const contentType = adminResponse.headers.get("content-type")
      if (contentType && contentType.includes("application/json")) {
        const adminSettings = await adminResponse.json()
        console.log("[PUBLIC HOMEPAGE SETTINGS] Successfully fetched admin settings:", adminSettings)
        return NextResponse.json(adminSettings)
      } else {
        console.warn("[PUBLIC HOMEPAGE SETTINGS] Admin API returned non-JSON response, using defaults")
        return NextResponse.json(defaultSettings)
      }
    } else {
      console.warn(`[PUBLIC HOMEPAGE SETTINGS] Admin API failed with status ${adminResponse.status}, using defaults`)
      return NextResponse.json(defaultSettings)
    }
  } catch (error) {
    console.error("[PUBLIC HOMEPAGE SETTINGS] Error fetching settings:", error)
    return NextResponse.json(defaultSettings)
  }
}
