// app/api/suggest/route.ts
import { NextResponse } from 'next/server';

export async function GET(req: Request) {
  const { searchParams } = new URL(req.url);
  const q = searchParams.get('q');

  if (!q) return NextResponse.json([]);

  const res = await fetch(
    `https://suggestqueries.google.com/complete/search?client=firefox&q=${q}`
  );

  const data = await res.json();
  return NextResponse.json(data[1] || []);
}
