import { NextResponse } from "next/server";
// import OpenAI from "openai";
// import { connectDB } from "@/lib/db";
// import SearchCache from "@/models/SearchCache";

// const openai = new OpenAI({
//   apiKey: process.env.OPENAI_API_KEY!,
// });

export async function GET(req: Request) {
  const { searchParams } = new URL(req.url);
  const query = searchParams.get("q");

  if (!query) {
    return NextResponse.json(
      { error: "Query is required" },
      { status: 400 }
    );
  }

//   await connectDB();

  // 1️⃣ Check cache
//   const cached = await SearchCache.findOne({ query });
//   if (cached) {
//     return NextResponse.json({
//       source: "cache",
//       ...cached.toObject(),
//     });
//   }

  // 2️⃣ DuckDuckGo search
  const ddgRes = await fetch(
    `https://api.duckduckgo.com/?q=${encodeURIComponent(
      query
    )}&format=json&no_html=1&skip_disambig=1`
  );

  const ddgData = await ddgRes.json();

  const results = (ddgData.RelatedTopics || [])
    .filter((item: any) => item.Text && item.FirstURL)
    .slice(0, 5)
    .map((item: any) => ({
      title: item.Text.split("-")[0],
      link: item.FirstURL,
      snippet: item.Text,
    }));

  // 3️⃣ AI Summary
//   const completion = await openai.chat.completions.create({
//     model: "gpt-4o-mini",
//     messages: [
//       {
//         role: "system",
//         content:
//           "You summarize search results in a concise, factual way.",
//       },
//       {
//         role: "user",
//         content: `Summarize the topic "${query}" using these points:\n${results
//           .map((r) => r.snippet)
//           .join("\n")}`,
//       },
//     ],
//   });

//   const aiSummary = completion.choices[0].message.content;

  // 4️⃣ Save to DB
//   const saved = await SearchCache.create({
//     query,
//     results,
//     aiSummary,
//   });

  return NextResponse.json({
    source: "fresh",
    query,
    results,
    // aiSummary,
  });
}
