import { type NextRequest, NextResponse } from "next/server"
import { validatePasswordResetToken } from "@/lib/typesense"

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const token = searchParams.get("token")

    if (!token) {
      return NextResponse.json({ error: "Token is required" }, { status: 400 })
    }

    const isValid = await validatePasswordResetToken(token)

    if (isValid) {
      return NextResponse.json({ valid: true })
    } else {
      return NextResponse.json({ error: "Invalid or expired token" }, { status: 400 })
    }
  } catch (error) {
    console.error("Token validation error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
