import { type NextRequest, NextResponse } from "next/server"
import { updateUserPassword } from "@/lib/typesense"

export async function POST(request: NextRequest) {
  try {
    const { userId, currentPassword, newPassword } = await request.json()

    if (!userId || !currentPassword || !newPassword) {
      return NextResponse.json({ error: "All fields are required" }, { status: 400 })
    }

    if (newPassword.length < 6) {
      return NextResponse.json({ error: "New password must be at least 6 characters long" }, { status: 400 })
    }

    const success = await updateUserPassword(userId, currentPassword, newPassword)

    if (!success) {
      return NextResponse.json({ error: "Current password is incorrect" }, { status: 401 })
    }

    return NextResponse.json({ success: true, message: "Password updated successfully" })
  } catch (error) {
    console.error("Password reset error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
