import { type NextRequest, NextResponse } from "next/server"
import { resetPasswordWithToken } from "@/lib/typesense"

export async function POST(request: NextRequest) {
  try {
    const { token, password } = await request.json()

    if (!token || !password) {
      return NextResponse.json({ error: "Token and password are required" }, { status: 400 })
    }

    if (password.length < 6) {
      return NextResponse.json({ error: "Password must be at least 6 characters long" }, { status: 400 })
    }

    const success = await resetPasswordWithToken(token, password)

    if (success) {
      return NextResponse.json({ message: "Password reset successfully" })
    } else {
      return NextResponse.json({ error: "Invalid or expired token" }, { status: 400 })
    }
  } catch (error) {
    console.error("Password reset error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
