import { type NextRequest, NextResponse } from "next/server"
import { generateNewVerificationToken, getUserByEmail } from "@/lib/typesense"
import { sendVerificationEmail } from "@/lib/email"

export async function POST(request: NextRequest) {
  try {
    const { email } = await request.json()

    if (!email) {
      return NextResponse.json({ error: "Email is required" }, { status: 400 })
    }

    const token = await generateNewVerificationToken(email)

    if (!token) {
      return NextResponse.json({ error: "User not found or already verified" }, { status: 400 })
    }

    const username = await getUserByEmail(email)
    if(!username){
      return NextResponse.json({ error: "User not found" }, { status: 400 })
    }

    console.log(username.username)
    // Send verification email
    await sendVerificationEmail(email, username.username, token)

    return NextResponse.json({
      success: true,
      message: "Verification email sent successfully",
    })
  } catch (error) {
    console.error("Resend verification error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
