import { type NextRequest, NextResponse } from "next/server"
import { getUserByEmail, generatePasswordResetToken } from "@/lib/typesense"
import { sendPasswordResetEmail } from "@/lib/email"

export async function POST(request: NextRequest) {
  try {
    const { email } = await request.json()

    if (!email) {
      return NextResponse.json({ error: "Email is required" }, { status: 400 })
    }

    // Check if user exists
    const user = await getUserByEmail(email)
    console.log(user)
    if (!user) {
      // Don't reveal if email exists or not for security
      return NextResponse.json({ message: "If an account with that email exists, a reset link has been sent." })
    }

    const resetToken = await generatePasswordResetToken(user.id)

    if (!resetToken) {
      return NextResponse.json({ error: "Failed to generate reset token" }, { status: 500 })
    }

    // Send reset email
    const resetUrl = `${process.env.NEXT_PUBLIC_APP_URL || "http://localhost:3000"}/reset-password?token=${resetToken}`
    console.log(resetUrl)
    // await sendPasswordResetEmail(email, user.username, resetUrl)

    return NextResponse.json({ message: "Password reset email sent successfully" })
  } catch (error) {
    console.error("Forgot password error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
