import { type NextRequest, NextResponse } from "next/server"
import { checkUsernameAvailability } from "@/lib/typesense"

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const username = searchParams.get("username")

    if (!username) {
      return NextResponse.json({ error: "Username is required" }, { status: 400 })
    }

    if (username.length < 3) {
      return NextResponse.json({ available: false, reason: "Username must be at least 3 characters" })
    }

    const available = await checkUsernameAvailability(username)

    return NextResponse.json({ available })
  } catch (error) {
    console.error("Username check error:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
