import { type NextRequest, NextResponse } from "next/server"
import { searchAllAds } from "@/lib/typesense"
//app/api/as/route.ts
export async function GET(request: NextRequest) {
  try {
    if (!process.env.TYPESENSE_API_KEY || !process.env.TYPESENSE_HOST) {
      return NextResponse.json({
        success: false,
        error: "Typesense is not configured",
        ads: [],
      })
    }

    const { searchParams } = new URL(request.url)
    const query = searchParams.get("q") || ""
    const limit = Number.parseInt(searchParams.get("limit") || "4")

    console.log("[v0] Ads API called with query:", query, "limit:", limit)

    const result = await searchAllAds({
      query,
      type: "ads",
      safeSearch: true,
      dateFilter: "all",
      limit,
    })

    console.log("[v0] searchAllAds returned:", {
      totalResults: result.total,
      adminAdsCount: result.results.filter((ad) => !ad.isUserAd).length,
      userAdsCount: result.results.filter((ad) => ad.isUserAd).length,
      results: result.results.map((ad) => ({
        id: ad.id,
        title: ad.title,
        isUserAd: ad.isUserAd,
        keywords: ad.keywords,
      })),
    })

    return NextResponse.json({
      success: true,
      ads: result.results,
      total: result.total,
    })
  } catch (error) {
    console.error("[v0] Error serving ads:", error)
    return NextResponse.json({
      success: false,
      error: error instanceof Error ? error.message : "Unknown error occurred",
      ads: [],
    })
  }
}
