import { type NextRequest, NextResponse } from "next/server"
import { searchUsers, getUserStats } from "@/lib/typesense"

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const search = searchParams.get("search") || ""
    const status = searchParams.get("status") || "all"

    console.log("[ADMIN USERS] Fetching users with search:", search, "status:", status)

    // Get users and stats
    const [users, stats] = await Promise.all([searchUsers(search, status), getUserStats()])

    console.log("[ADMIN USERS] Found", users.length, "users")

    return NextResponse.json({
      users,
      stats,
      success: true,
    })
  } catch (error) {
    console.error("[ADMIN USERS] Error fetching users:", error)
    return NextResponse.json({ error: "Failed to fetch users", success: false }, { status: 500 })
  }
}
